/*
 *  Copyright (C) 1998-2000 EPITA-LRDE    
 *  EPITA Research and Development Laboratory
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include <assert.h>
#include <time.h>


const int border = 1;


typedef enum
{
  CHAR
}
type_t;

struct
{
  int iRow;
  int iCol;
}
delta[4] = { {-1,0}, {0,-1}, {0,1}, {1,0} };

typedef struct
{
  int		nRows;
  int		nCols;
  type_t	type;
  void*		data;
  void*		data_end;
  void*		array;
  signed long   delta[4];
}
Image2D;



Image2D* new_Image2D( int nRows, int nCols, type_t type )
{
  Image2D* image = NULL;
  size_t size = 0;
  assert( nRows > 0 && nCols > 0 );
  image = (Image2D*)malloc( sizeof( Image2D ) );
  assert( image != NULL );
  image->nRows = nRows;
  image->nCols = nCols;
  image->type = type;
  size = ( (size_t)nRows + 2 * border ) * ( (size_t)nCols + 2 * border );
  switch ( type )
    {
    case CHAR:
      size *= sizeof( signed char );
      image->data = malloc( size );
      assert( image->data != NULL );
      {
	int iRow;
	char** array = (char**)malloc( ( image->nRows + 2 * border ) * sizeof( char* ) );
	size_t offset = (size_t)nCols + 2 * border;
	char* data = (char*)( image->data ) + offset * border + border;
	assert( array != NULL );
	array += border;
	for ( iRow = - border; iRow < image->nRows + border; ++iRow )
	  {
	    array[iRow] = data + iRow * offset;
	  }
	image->array = (void*)array;
	image->data_end = (void*)(data + image->nRows * offset - 2 * border);

	{
	  int i;
	  for (i = 0; i<4; ++i)
	    image->delta[i] = delta[i].iRow * offset + delta[i].iCol;
	}
      }
      break;
    }
  return image;
}



void test_Image2D( Image2D* image )
{
  assert( image != NULL );
  assert( image->data != NULL );
  assert( image->array != NULL );
}


void delete_Image2D( Image2D* image )
{
  test_Image2D( image );
  free( image->data );
  image->data = NULL;
  free( (char**)( image->array ) - border );
  free( image );
}



void pretiffy( Image2D* image )
{
  int iRow, iCol;
  test_Image2D( image );
  assert( image != NULL && image->data != NULL );
  switch ( image->type )
    {
    case CHAR:
      {
	char** array = (char**)( image->array );
	for ( iRow = 0; iRow < image->nRows; ++iRow )
	  for ( iCol = 0; iCol < image->nCols; ++iCol )
	    {
	      array[iRow][iCol] = iCol + 10 * iRow;
	    }
      }
      break;
    }
}



void print( Image2D* image )
{
  int iRow, iCol;
  test_Image2D( image );
  assert( image != NULL && image->data != NULL );
  switch ( image->type )
    {
    case CHAR:
      {
	char** array = (char**)( image->array );
	for ( iRow = 0; iRow < image->nRows; ++iRow )
	  {
	    for ( iCol = 0; iCol < image->nCols; ++iCol )
	      {
		printf( "%d ", array[iRow][iCol] );
	      }
	    printf( "\n" );
	  }
	printf( "\n" );
      }
      break;
    }
}



void add( Image2D* image, void* pval )
{
  test_Image2D( image );
  switch ( image->type )
    {
    case CHAR:
      {
	char   val   = *( (char*)( pval ) );
	char   *pos  = (char*)(image->data);
	char   *pos_end = (char*)(image->data_end);

	for ( ; pos < pos_end; ++pos )
	  *pos += val;
      }
      break;
    }
}


void mean( Image2D* inputImage, Image2D* outputImage )
{
  int iNeigh;
  test_Image2D( inputImage );
  test_Image2D( outputImage );
  assert( inputImage->type == outputImage->type
	  && inputImage->nRows == outputImage->nRows 
	  && inputImage->nCols == outputImage->nCols );

  switch ( inputImage->type )
    {
    case CHAR:
      {
	char* ipos = (char*)(inputImage->data);
	char* iend = (char*)(inputImage->data_end);
	char* opos = (char*)(outputImage->data);
	signed long *delta = (signed long*)(inputImage->delta);
        for ( ; ipos < iend; ++ipos, ++opos )
	  {
	    short sum = 0;
	    for ( iNeigh = 0; iNeigh < 4; ++iNeigh )
	      {
		sum += ipos[delta[iNeigh]];
	      }
	      *opos = sum / 4;
	    }
      }
      break;
    }
}



int main()
{
  Image2D* image = NULL;
  char val = 7;
  const int n = 1;
  int i;
  float t0;
  image = new_Image2D( 2048, 4096, CHAR );
  {
    t0 = (float)clock();
    for ( i = 0; i < n; ++i )
      {
	add( image, &val );
      }
    printf( "add (C classic w/ offsets): %.3f s\n", ( clock() - t0 ) / CLOCKS_PER_SEC / n );
  }
  {
    t0 = (float)clock();
    for ( i = 0; i < n; ++i )
      {
	mean( image, image );
      }
    printf( "mean (C classic w/ offsets): %.3f s\n", ( clock() - t0 ) / CLOCKS_PER_SEC / n );
  }
  return 0;
}
