// Copyright (C) 1998-2000 EPITA-LRDE    
// EPITA Research and Development Laboratory


#ifndef ITERATOR_HH
#define ITERATOR_HH



template<class Data> class NeighborIterator;



template<class Data> 
class Iterator
{
public:
  
  virtual void first() = 0;
  virtual bool isDone() const = 0;
  virtual Data& value() = 0;
  virtual void next() = 0;
  virtual unsigned getCard() const = 0;
  virtual Iterator<Data>& createNeighborIterator() = 0;
  virtual ~Iterator()
    {
    }

};



#define  for_each( ITER )  for ( ITER.first(); ! ITER.isDone(); ITER.next() )



#endif // ITERATOR_HH
