// Copyright (C) 1998-2000 EPITA-LRDE    
// EPITA Research and Development Laboratory  (lrde@epita.fr) 

#ifndef IMAGE3D_HH
#define IMAGE3D_HH

#include <iostream>



extern const int border;


template<class Data> class Image3DIterator;
template<class Data> class Image3DNeighborIterator;


template<class Data> 
class Image3D
{
public:

  typedef Data                           DataType;
  typedef Image3DIterator<Data>          Iterator;
  // typedef Image3DFollowerIterator<Data>  FollowerIterator;
  typedef Image3DNeighborIterator<Data>  NeighborIterator;

  Image3D( int nSlis, int nRows, int nCols )
    {
      _nSlis = nSlis;
      _nRows = nRows;
      _nCols = nCols;
      _data = new Data**[ _nSlis + 2 * border ] + border;
      for ( int iSli = - border; iSli < _nSlis + border; ++iSli )
	{
	  _data[iSli] = new Data*[ _nRows + 2 * border ] + border;
	  for ( int iRow = - border; iRow < _nRows + border; ++iRow )
	    _data[iSli][iRow] = new Data[ _nCols + 2 * border ] + border;
	}
    }

  ~Image3D()
    {
      for ( int iSli = - border; iSli < _nSlis + border; ++iSli )
	{
	  for ( int iRow = - border; iRow < _nRows + border; ++iRow )
	    delete[] ( _data[iSli][iRow] - border );
	  delete[] ( _data[iSli] - border );
	}
      delete[] ( _data - border );
    }

  void print() const
    {
      for ( int iSli = 0; iSli < _nSlis; ++iSli )
	{
	  for ( int iRow = 0; iRow < _nRows; ++iRow )
	    {
	      for ( int iCol = 0; iCol < _nCols; ++iCol )
		cout << int( _data[iSli][iRow][iCol] ) << ' ';
	      cout << endl;
	    }
	  cout << endl;
	}
      cout << endl;	  
    }

  int nRows() const
    {
      return _nRows;
    }

  int nCols() const
    {
      return _nCols;
    }

  int nSlis() const
    {
      return _nSlis;
    }

  Data& value( int iSli, int iRow, int iCol )
    {
      return _data[iSli][iRow][iCol];
    }

  void prettify()
    {
      for ( int iSli = 0; iSli < _nSlis; ++iSli )
	for ( int iRow = 0; iRow < _nRows; ++iRow )
	  for ( int iCol = 0; iCol < _nCols; ++iCol )
	    {
	      _data[iSli][iRow][iCol] = iSli * 100 + iRow * 10 + iCol;
	    }
    }
  
private:

  int     _nRows;
  int     _nCols;
  int     _nSlis;
  Data*** _data;
};





struct
{ 
  int dSli;
  int dRow;
  int dCol;
}
neighbor3D[6] = { {-1,0,0}, {0,-1,0}, {0,0,-1}, {0,0,1}, {0,1,0}, {1,0,0} };  





template<class Data> 
class Image3DNeighborIterator
{
public:

  Image3DNeighborIterator( Image3DIterator<Data>& iterator ) :
    _iterator( iterator )
    {
      first();
    }

  ~Image3DNeighborIterator()
    {
    }

  void first()
    {
      _v = 0;
    }

  bool isDone() const
    {
      return _v >= 6;
    }

  Data& value()
    {
      return _iterator._image.value( _iterator._iSli + neighbor3D[_v].dSli,
				     _iterator._iRow + neighbor3D[_v].dRow, 
				     _iterator._iCol + neighbor3D[_v].dCol );
    }

  void next()
    {
      ++_v;
    }

  unsigned getCard() const
    {
      return 6;
    }

private:
	
  unsigned _v;
  Image3DIterator<Data>& _iterator;
};





template<class Data> 
class Image3DIterator
{
public:

  Image3DIterator( Image3D<Data>& image ) :
    _image( image )
    {
      first();
    }

  ~Image3DIterator()
    {
    }

  void first()
    {
      _iSli = _iRow = _iCol = 0;
    }

  bool isDone() const
    {
      return _iSli >= _image.nSlis();
    }

  Data& value()
    {
      return _image.value( _iSli, _iRow, _iCol );
    }

  void next()
    {
      if ( ++_iCol >= _image.nCols() )  
	{
	  _iCol = 0;
	  if ( ++_iRow >= _image.nRows() )  
	    { 
	      _iRow = 0;
	      ++_iSli;
	    }
	}
    }

private:
	
  int _iSli;
  int _iRow;
  int _iCol;
  Image3D<Data>& _image;

  friend class Image3DNeighborIterator<Data>;
};




#endif // IMAGE3D_HH
