/*
 *  file gamma_visitor.cc
 *
 *  Copyright (C) 1999 EPITA-LRDE
 *  EPITA Research and Development Laboratory
 */

#include <iostream>



// fwd decl
class ConcreteElementA;
class ConcreteElementB;



// --------------------------  Visitor



class Visitor
{
public:
  virtual void VisitConcreteElementA( ConcreteElementA& e ) = 0;
  virtual void VisitConcreteElementB( ConcreteElementB& e ) = 0;
};



// --------------------------  Element



class Element
{
public:
  virtual void Accept( Visitor& v ) = 0;
};



// --------------------------  ConcreteElementA



class ConcreteElementA : public Element
{
public:
  virtual void Accept( Visitor& v )
    {
      v.VisitConcreteElementA( *this );
    }
};



// --------------------------  ConcreteElementB



class ConcreteElementB : public Element
{
public:
  virtual void Accept( Visitor& v )
    {
      v.VisitConcreteElementB( *this );
    }
};



// --------------------------  ConcreteVisitor1



class ConcreteVisitor1 : public Visitor
{
public:
  virtual void VisitConcreteElementA( ConcreteElementA& e )
    {
      std::cout << "ConcreteVisitor1::VisitConcreteElementA( ConcreteElementA& )" << std::endl;
    }
  virtual void VisitConcreteElementB( ConcreteElementB& e )
    {
      std::cout << "ConcreteVisitor1::VisitConcreteElementB( ConcreteElementB& )" << std::endl;
    }
};



// --------------------------  main



int main()
{
  ConcreteElementA e;
  e.Accept( *new ConcreteVisitor1() );
}
