/*
 *  file generic_bridge.cc
 *
 *  Copyright (C) 1999 EPITA-LRDE
 *  EPITA Research and Development Laboratory
 */

#include <iostream>


// --------------------------  Abstraction


template< typename I >
class Abstraction
{
public:
  Abstraction( I* imp_ ) :
    imp( imp_ )
  {
  }
  void Operation()
  {
    imp->OperationImp();
  }
protected:
  I* imp;
};



// --------------------------  RefinedAbstraction



template< typename I >
class RefinedAbstraction : public Abstraction<I>
{
public:
  RefinedAbstraction( I* imp_ ) :
    Abstraction<I>( imp_ )
  {
  }
};



// --------------------------  ConcreteImplementorA



class ConcreteImplementorA
{
public:
  void OperationImp()
  {
    std::cout << "ConcreteImplementorA::OperationImp" << std::endl;
  }
};



// --------------------------  ConcreteImplementorB



class ConcreteImplementorB
{
public:
  void OperationImp()
  {
    std::cout << "ConcreteImplementorB::OperationImp" << std::endl;
  }
};



// --------------------------  main



int main()
{
  typedef ConcreteImplementorA I;
  RefinedAbstraction<I> obj( new I() );
  obj.Operation();
}
