/*
 *  file generic_factory.cc
 *
 *  Copyright (C) 1999 EPITA-LRDE
 *  EPITA Research and Development Laboratory
 */

#include <iostream>



// --------------------------  ProductA?



class ProductA1
{
public:
  void echo() const
    {
      std::cout << "ProductA1" << std::endl;
    }
};



class ProductA2
{
public:
  void echo() const
    {
      std::cout << "ProductA2" << std::endl;
    }
};



// --------------------------  ProductB?



class ProductB1
{
public:
  void echo() const
    {
      std::cout << "ProductB1" << std::endl;
    }
};



class ProductB2
{
public:
  void echo() const
    {
      std::cout << "ProductB2" << std::endl;
    }
};



// --------------------------  Def_Product?<F>



template< class F >
struct Def_ProductA
{
  typedef  typename F::productA_type  type;
};



template< class F >
struct Def_ProductB
{
  typedef  typename F::productB_type  type;
};



// --------------------------  ConcreteFactory1



class ConcreteFactory1
{
public:
  typedef  ProductA1  productA_type;
  typedef  ProductB1  productB_type;
};



// --------------------------  ConcreteFactory2



class ConcreteFactory2
{
};



template<>
struct Def_ProductA< ConcreteFactory2 >
{
  typedef  ProductA2  type;
};



template<>
struct Def_ProductB< ConcreteFactory2 >
{
  typedef  ProductB2  type;
};



// --------------------------  foo<Factory>



template< class Factory >
void foo( Factory& factory )
{
  typename Def_ProductA< Factory >::type  a;
  a.echo();
}



// --------------------------  main



int main()
{
  ConcreteFactory2 factory;
  foo( factory );
}
