/*
 *  file gamma_decorator.cc
 *
 *  Copyright (C) 1999 EPITA-LRDE
 *  EPITA Research and Development Laboratory
 */

#include <iostream>



// --------------------------  Component



class Component
{
public:
  virtual void Operation() = 0;
};



// --------------------------  ConcreteComponent



class ConcreteComponent : public Component
{
public:
  virtual void Operation()
    {
      std::cout << "ConcreteComponent::Operation" << std::endl;
    }
};



// --------------------------  Decorator



class Decorator : public Component
{
public:
  Decorator( Component& component ) :
    _component( component )
    {
    }
  virtual void Operation()
    {
      _component.Operation();
    }
protected:
  Component& _component;
};



// --------------------------  ConcreteDecoratorA



class ConcreteDecoratorA : public Decorator
{
public:
  ConcreteDecoratorA( Component& component ) :
    Decorator( component )
    {
    }
  virtual void Operation()
    {
      Decorator::Operation();
      addedState = 1;
    }
protected:
  int addedState;
};



// --------------------------  ConcreteDecoratorB



class ConcreteDecoratorB : public Decorator
{
public:
  ConcreteDecoratorB( Component& component ) :
    Decorator( component )
    {
    }
  virtual void Operation()
    {
      Decorator::Operation();
      AddedBehaviour();
    }
protected:
  void AddedBehaviour()
    {
      std::cout << "ConcreteDecoratorB::AddedBehaviour" << std::endl;
    }
};



// --------------------------  main



int main()
{
  ConcreteDecoratorB  cb( *new ConcreteComponent() );
  cb.Operation();
}
