/*
 *  file generic_iterator.hh
 *
 *  Copyright (C) 1999 EPITA-LRDE
 *  EPITA Research and Development Laboratory
 */



// fwd decl
template< typename T > class ConcreteIterator;



// --------------------------  ConcreteAggregate<T>



template< typename T >
class ConcreteAggregate
{
public:
  typedef T value_type;
  typedef ConcreteIterator<T> iterator_type;
  ConcreteAggregate();
  ConcreteIterator<T>& CreateIterator();
  const T& value_at( unsigned index ) const;
  T& value_at( unsigned index );
  unsigned size() const;
private:
  T _value[10];
};



// --------------------------  ConcreteIterator<T>



template< typename T >
class ConcreteIterator
{
public:
  ConcreteIterator( ConcreteAggregate<T>& aggregate );
  void First();
  void Next();
  bool IsDone() const;
  T& CurrentItem();
private:
  ConcreteAggregate<T>& _aggregate;
  unsigned _index;
};



// --------------------------  proc



template< typename A >
void add( A& input, typename A::value_type value );
