/*
 *  file get.hh
 *
 *  Copyright (C) 1999 EPITA-LRDE
 *  EPITA Research and Development Laboratory
 *  lrde@epita.fr
 */

#ifndef GET_HH
#define GET_HH


// typename T means an iterator


#define define_get( A ) \
template< typename T > \
struct get_##A \
{ \
  typedef  T  input_type; \
  typedef  typename T::A##_type  output_type; \
  output_type& operator()( input_type& val ) \
    { \
      return val.A; \
    } \
  const output_type& operator()( const input_type& val ) const \
    { \
      return val.A; \
    } \
};



template< typename T >
struct get_value
{
  typedef  T  input_type;
  typedef  T  output_type;
  output_type& operator()( input_type& val )
    {
      return val;
    }
  const output_type& operator()( const input_type& val ) const
    {
      return val;
    }
};



#endif
