/*
 *  file rgb.hh
 *
 *  Copyright (C) 1999 EPITA-LRDE
 *  EPITA Research and Development Laboratory
 *  lrde@epita.fr
 */

#ifndef RGB_HH
#define RGB_HH



template< typename T >
struct rgb
{

  rgb() :
    red( T() ), green( T() ), blue( T() )
    {
    }

  rgb( T val ) :
    red( val ), green( val ), blue( val )
    {
    }

  rgb( T red_, T green_, T blue_ ) :
    red( red_ ), green( green_ ), blue( blue_ )
    {
    }

  rgb( const rgb<T>& rhs ) :
    red( rhs.red ), green( rhs.green ), blue( rhs.blue )
    {
    }

  rgb<T>& operator=( const rgb<T>& rhs )
    {
      red = rhs.red;  green = rhs.green;  blue = rhs.blue;
      return *this;
    }

  rgb<T>& operator+=( const rgb<T>& rhs )
    {
      red += rhs.red;  green += rhs.green;  blue += rhs.blue;      
      return *this;
    }

  rgb<T>& operator-=( const rgb<T>& rhs )
    {
      red -= rhs.red;  green -= rhs.green;  blue -= rhs.blue;      
      return *this;
    }

  bool operator==( const rgb<T>& rhs ) const
    {
      return red == rhs.red && green == rhs.green && blue == rhs.blue;
    }

  T red, green, blue;

  typedef T red_type;
  typedef T green_type;
  typedef T blue_type;

};



template< typename T >
inline ostream& operator<<( ostream& ostr, const rgb<T>& obj )
{
  return ostr << '(' << obj.red << ',' 
              << obj.green << ','
              << obj.blue << ')';
}



#include "get.hh"
define_get( red );
define_get( green );
define_get( blue );



#endif
