/*
 *  file diamond.cc
 *
 *  Copyright (C) 2000 EPITA-LRDE
 *  EPITA Research and Development Laboratory
 */

#include <iostream>



// ConceptTop


template< class ModelTop >
struct ConceptTop_traits {};


template< class ModelTop >
struct ConceptTop
{
  typedef typename ConceptTop_traits< ModelTop >::TypeB  B; // declared only once => no ambiguity
  void meth() { this->self().meth_impl(); }
protected:
  ModelTop& self()
   { return static_cast< ModelTop& >( *this ); }
};



// ConceptMiddle1


template< class ModelMiddle1 >
struct ConceptMiddle1_traits {};


template< class ModelMiddle1 >
struct ConceptMiddle1 : public ConceptTop< ModelMiddle1 >
{
};



// ConceptMiddle2


template< class ModelMiddle2 >
struct ConceptMiddle2_traits {};


template< class ModelMiddle2 >
struct ConceptMiddle2 : public ConceptTop< ModelMiddle2 >
{
};



// ConceptBottom


template< class ModelBottom >
struct ConceptBottom_traits {};


template< class ModelBottom >
struct ConceptBottom : public ConceptMiddle1< ModelBottom >,
		       public ConceptMiddle2< ModelBottom >
{
  void meth() { this->self().meth_impl(); } // fix ambiguity
protected:
  ModelBottom& self()
   { return static_cast< ModelBottom& >( *this ); }
};



// generic procedures


template< class ModelBottom >
void foo( ConceptBottom< ModelBottom >& data )
{
  std::cout << "foo( ConceptBottom ):" << std::endl;
  typename ConceptBottom< ModelBottom >::B*  b;
  b = 0;
  data.meth();
}



// a class


struct ClassB {};



// M is a model of every concepts


struct M;


template<>
struct ConceptTop_traits< M >
{
  typedef ClassB TypeB;
};


template<>
struct ConceptMiddle1_traits< M > : public ConceptTop_traits< M >
{
};

template<>
struct ConceptMiddle2_traits< M > : public ConceptTop_traits< M >
{
};

template<>
struct ConceptBottom_traits< M > : public ConceptMiddle1_traits< M >,
				   public ConceptMiddle2_traits< M >
{
};


struct M : public ConceptBottom< M >
{
  void meth_impl()
  {
    std::cout << "M::meth_impl()" << std::endl;
  }
};



// main


int main()
{
  M m;
  foo( m );
}
