/*
 *  file multicompliance.cc
 *
 *  Copyright (C) 2000 EPITA-LRDE
 *  EPITA Research and Development Laboratory
 */

#include <iostream>



// Concept1


template< class Model1 >
struct Concept1_traits {};


template< class Model1 >
struct Concept1
{
  typedef typename Concept1_traits< Model1 >::TypeB  B;
  void meth() { self().meth_impl(); }
protected:
  Model1& self()
   { return static_cast< Model1& >( *this ); }
};



// Concept2


template< class Model2 >
struct Concept2_traits {};


template< class Model2 >
struct Concept2
{
  typedef typename Concept2_traits< Model2 >::TypeB  B;
  typedef typename Concept2_traits< Model2 >::TypeD  D;
  void meth() { self().meth_impl(); }
  void meth2() { self().meth2_impl(); }
protected:
  Model2& self()
   { return static_cast< Model2& >( *this ); }
};



// procedures


template< class Model1 >
void foo( Concept1< Model1 >& data )
{
  std::cout << "foo( Concept1 ):" << std::endl;
  typename Concept1< Model1 >::B*  b;
  b = 0;
  data.meth();
}


template< class Model2 >
void bar( Concept2< Model2 >& data )
{
  std::cout << "bar( Concept2 ):" << std::endl;
  typename Concept2< Model2 >::B*  b;
  b = 0;
  typename Concept2< Model2 >::D*  d;
  d = 0;
  data.meth();
  data.meth2();
}



// some classes


struct ClassB {};
struct ClassD {};



// M is a model of both Concept1 and Concept2


struct M;


template<>
struct Concept1_traits< M >
{
  typedef ClassB TypeB;
};


template<>
struct Concept2_traits< M >
{
  typedef ClassB TypeB;
  typedef ClassD TypeD;
};


struct M : public Concept1< M >, public Concept2< M >
{
  void meth_impl()
  {
    std::cout << "M::meth_impl()" << std::endl;
  }
  void meth2_impl()
  {
    std::cout << "M::meth2_impl()" << std::endl;
  }
};



// main


int main()
{
  M m;

  foo( m );
  std::cout << std::endl;

  bar( m );
}
