/*
 *  file refinement.cc
 *
 *  Copyright (C) 2000 EPITA-LRDE
 *  EPITA Research and Development Laboratory
 */

#include <iostream>



// ConceptBase1


template< class ModelBase1 >
struct ConceptBase1_traits {};


template< class ModelBase1 >
struct ConceptBase1
{
  typedef typename ConceptBase1_traits< ModelBase1 >::TypeB  B;
  void meth() { this->self().meth_impl(); }
  void meth1() { this->self().meth1_impl(); }
protected:
  ModelBase1& self()
   { return static_cast< ModelBase1& >( *this ); }
};



// ConceptBase2


template< class ModelBase2 >
struct ConceptBase2_traits {};


template< class ModelBase2 >
struct ConceptBase2
{
  typedef typename ConceptBase2_traits< ModelBase2 >::TypeB  B;
  typedef typename ConceptBase2_traits< ModelBase2 >::TypeD  D;
  void meth() { this->self().meth_impl(); }
  void meth2() { this->self().meth2_impl(); }
protected:
  ModelBase2& self()
   { return static_cast< ModelBase2& >( *this ); }
};



// ConceptR refines both ConceptBase1 and ConceptBase2


template< class ModelR >
struct ConceptR_traits {};


template< class ModelR >
struct ConceptR : public ConceptBase1< ModelR >,
		  public ConceptBase2< ModelR >
{
  typedef typename ConceptR_traits< ModelR >::TypeB  B; // fix ambiguity
  typedef typename ConceptR_traits< ModelR >::TypeE  E;
  void meth() { this->self().meth_impl(); } // fix ambiguity
  void methR() { this->self().methR_impl(); }
protected:
  ModelR& self()
   { return static_cast< ModelR& >( *this ); }
};



// generic procedures


template< class ModelBase1 >
void foo( ConceptBase1< ModelBase1 >& data )
{
  std::cout << "foo( ConceptBase1 ):" << std::endl;
  typename ConceptBase1< ModelBase1 >::B*  b;
  b = 0;
  data.meth();
  data.meth1();
}


template< class ModelR >
void bar( ConceptR< ModelR >& data )
{
  std::cout << "bar( ConceptR ):" << std::endl;
  typename ConceptR< ModelR >::B*  b;
  b = 0;
  typename ConceptR< ModelR >::D*  d;
  d = 0;
  typename ConceptR< ModelR >::E*  e;
  e = 0;
  data.meth();
  data.meth1();
  data.meth2();
  data.methR();
}


template< class ModelR >
void base( ConceptR< ModelR >& data )
{
  std::cout << "base( ConceptR ):" << std::endl;
  foo( data );
}



// some classes


struct ClassB {};
struct ClassD {};
struct ClassE {};



// M is a model of ConceptR


struct M;


template<>
struct ConceptBase1_traits< M >
{
  typedef ClassB TypeB;
};

template<>
struct ConceptBase2_traits< M >
{
  typedef ClassB TypeB;
  typedef ClassD TypeD;
};

template<>
struct ConceptR_traits< M > : public ConceptBase1_traits< M >,
			      public ConceptBase2_traits< M >
{
  typedef ClassB TypeB; // fix ambiguity
  typedef ClassE TypeE;
};


struct M : public ConceptR< M >
{
  void meth_impl()
  {
    std::cout << "M::meth_impl()" << std::endl;
  }
  void meth1_impl()
  {
    std::cout << "M::meth1_impl()" << std::endl;
  }

  void meth2_impl()
  {
    std::cout << "M::meth2_impl()" << std::endl;
  }

  void methR_impl()
  {
    std::cout << "M::methR_impl()" << std::endl;
  }
};



// main


int main()
{
  M m;

  foo( m );
  std::cout << std::endl;

  bar( m );
  std::cout << std::endl;

  base( m );
}
