/*
 *  file sutter1.cc
 *
 *  Copyright (C) 2000 EPITA-LRDE
 *  EPITA Research and Development Laboratory
 */

#include <assert.h>
#include <iostream>


template< class ModelA >
class ConceptA
{
private:
  bool ValidateRequirements()
  {
    void (ModelA::*meth_ptr)() = &ModelA::meth; // checks exact signature :)
    meth_ptr = 0; // just to avoid a warning
    return true;
  }
public:
  ~ConceptA()
  {
    assert( ValidateRequirements() ); // forces requirement validation :)
  }
};


template< class ModelA >
void foo( ModelA& data ) // no concept presence in signature :((
{
  ConceptA< ModelA >(); // validates requirements at compile time :)
  data.meth();
}


struct A1
{
  void meth()
  {
    std::cout << "A1::meth()" << std::endl;
  }
};


int main()
{
  A1 a;
  foo( a );
}
