#include <iostream>
using std::cout;
using std::endl;

#include "exact_type.hh"



//
//  F_EQ
//
//////////////////////////////////////////////////////////////////////


template<class I = Bottom>
struct F_EQ
  : public Void< F_EQ<I> >
{
  typedef F_EQ<I> This;

  bool operator==(const This& rhs) const {
    return to_exact(this)->eq(to_exact(rhs));
  }
};



//
//  operator!=
//
//////////////////////////////////////////////////////////////////////


template<class T>
bool operator!=(const F_EQ<T>& lhs,
		const F_EQ<T>& rhs) {
  return ! lhs.operator==(rhs);
}



//
//  Point
//
//////////////////////////////////////////////////////////////////////


template<class I = Bottom>
struct Point
  : public F_EQ< Point<I> >
{
  typedef Point<I> This;

  Point(int x, int y) :
    x(x),
    y(y) {
  }
  bool eq(const This& rhs) const {
    return x == rhs.x && y == rhs.y;
  }
protected:
  int x, y;
};



//
//  ColorPoint
//
//////////////////////////////////////////////////////////////////////


template<class I = Bottom>
struct ColorPoint :
  public Point< ColorPoint<I> >
{
  typedef ColorPoint<I> This;
  typedef Point<This> Super;

  ColorPoint(int x, int y, int c) :
    Super(x, y),
    c(c) {
  }
  bool eq(const This& rhs) const {
    return Super::eq(rhs) && c == rhs.c;
  }
protected:
  int c;
};



//
//  foo
//
//////////////////////////////////////////////////////////////////////


template<class P>
void foo(const Point<P>& p1, const Point<P>& p2) {
  cout << (p1 == p2 ? "true" : "false")
       << endl;
}



//
//  main
//
//////////////////////////////////////////////////////////////////////


int main()
{
  Point<>      a(0,5);
  ColorPoint<> b(0,5,1);
  ColorPoint<> c(0,5,1);

  foo(a, b);  // error at compile-time
  foo(b, c);  // true
}
