// this file goes with the paper:
// Alexandre Duret-Lutz, Thierry Geraud, and Akim Demaille.
// Generic Design Patterns in C++. In the Proceedings of the 6th
// USENIX Conference on Object-Oriented Technologies and Systems (COOTS),
// pages 189-202, San Antonio, Texas, USA, January-February 2001.


#include <iostream>
using std::cout;
using std::endl;



class ConcreteComponent {
public:
  void Operation() {
    cout << "ConcreteComponent::Operation" << endl;
  }
};



template<class C>
class ConcreteDecoratorA : public C
{
public:
  void Operation() {
    C::Operation();
    addedState = 1;
  }
protected:
  int addedState;
};



template<class C>
class ConcreteDecoratorB : public C
{
public:
  void Operation() {
    C::Operation();
    AddedBehaviour();
  }
protected:
  void AddedBehaviour() {
    cout << "ConcreteDecoratorB::AddedBehaviour" << endl;
  }
};



int main()
{
  ConcreteDecoratorB<ConcreteComponent> cb;
  cb.Operation();
}
