
#include <iostream>
using std::cout;
using std::endl;

#include "exact_type.hh"


//
//  ``Diamond-shaped'' recurring hierarchy:
//
//     A*
//    /  \
//   B1*  B2*
//    \  /  \
//     C1*   C2*
//       \  /
//        D*
//
//////////////////////////////////////////////////////////////////////



template<class I = Bottom>
class A : public Void< A<I> > {
public:
  void echo() {
    cout << "A" << endl;
  }
};


template<class I = Bottom>
class B1 : public A< B1<I> > {
public:
  void echo() {
    cout << "B1" << endl;
  }
};


template<class I = Bottom>
class B2 : public A< B2<I> > {
public:
  void echo() {
    cout << "B2" << endl;
  }
};


template<class I = Bottom>
class C1 :
  public B1< C1<I> >,
  public B2< C1<I> >
{
public:
  void echo() {
    cout << "C1" << endl;
  }
};


template<class I = Bottom>
class C2 : public B2< C2<I> > {
public:
  void echo() {
    cout << "C2" << endl;
  }
};


template<class I = Bottom>
class D :
  public C1< D<I> >,
  public C2< D<I> >
{
public:
  void echo() {
    cout << "D" << endl;
  }
};



//
//  strong statically typed foo
//
//////////////////////////////////////////////////////////////////////


template<class T>
void foo(A<T>& a) {
  to_exact(a).echo();
}



//
//  main
//
//////////////////////////////////////////////////////////////////////


int main() {
  D<> d;
  foo(solve_cast<B1>(d));
  foo(solve_cast<C2>(d));
}
