
#ifndef EXACT_TYPE_HH
#define EXACT_TYPE_HH



//
//  Top, Bottom, and Void
//
//////////////////////////////////////////////////////////////////////


class Top {
protected:
  Top() {}
};


class Bottom {
private:
  Bottom();
};


template<class I = Bottom>
class Void : public Top {
protected:
  Void() {}
};




//
//  inferior traits
//
//////////////////////////////////////////////////////////////////////


template<class>
struct inferior;

template<template<class> class C,
         class I>
struct inferior< C<I> > {
 typedef I type;
};

// special mixin:

template<template<template<class> class, class> class M,
         template<class> class S,
         class I>
struct inferior< M<S,I> > {
 typedef I type;
};




//
//  exact traits
//
//////////////////////////////////////////////////////////////////////


namespace misc {

  template<class T>
  struct find_exact;

  template<class T, class I>
  struct helper {
   typedef typename find_exact<I>::type type;
  };

  template<class T>
  struct helper<T, Bottom> {
   typedef T type;
  };

  template<class T>
  struct find_exact {
   typedef typename inferior<T>::type I;
   typedef typename helper<T,I>::type type;
  };
}

template<class T>
struct exact {
 typedef typename misc::find_exact<T>::type type;
};




//
//  exact proc
//
//////////////////////////////////////////////////////////////////////


template<class T>
typename exact<T>::type* to_exact(Void<T>* ptr) {
  return static_cast<typename exact<T>::type*>(ptr);
}

template<class T>
const typename exact<T>::type* to_exact(const Void<T>* ptr) {
  return static_cast<const typename exact<T>::type*>(ptr);
}

template<class T>
typename exact<T>::type& to_exact(Void<T>& ref) {
  return static_cast<typename exact<T>::type&>(ref);
}

template<class T>
const typename exact<T>::type& to_exact(const Void<T>& ref) {
  return static_cast<const typename exact<T>::type&>(ref);
}



//
//  solve_cast traits
//
//////////////////////////////////////////////////////////////////////


template<template<class> class C,
         class T>
C<T>& solve_cast(C<T>& obj) { return obj; }

template<template<class> class C,
         class T>
const C<T>& solve_cast(const C<T>& obj) { return obj; }

template<template<class, class> class C,
         class T1, class T2 >
C<T1,T2>& solve_cast(C<T1,T2>& obj) { return obj; }

template<template<class, class> class C,
         class T1, class T2 >
const C<T1,T2>& solve_cast(const C<T1,T2>& obj) { return obj; }

template<template<class, class, class> class C,
         class T1, class T2, class T3 >
C<T1,T2,T3>& solve_cast(C<T1,T2,T3>& obj) { return obj; }

template<template<class, class, class> class C,
         class T1, class T2, class T3 >
const C<T1,T2,T3>& solve_cast(const C<T1,T2,T3>& obj) { return obj; }



#endif
