#include <iostream>
using std::cout;
using std::endl;

#include "static_isa.h"


//
//  interfaces and concrete classes
//
//////////////////////////////////////////////////////////////////////


struct D {
protected: D() {}
};


struct D1 : public D {
};


struct E {
protected: E() {}
};


struct E1 : public E {
};


struct F {
protected: F() {}
};


struct F1 : public F {
};



//
//  overloaded functions
//
//////////////////////////////////////////////////////////////////////


struct bar_DE {
  template<class D, class E>
  static void exec(D& d, E& e) {
    cout << "bar_DE::exec" << endl;
  }
};


struct bar_DF {
  template<class D, class F>
  void exec(D& d, F& f) {
    cout << "bar_DF" << endl;
  }
};


template<class D, class T>
void bar(D& d, T& t) {
  typedef typename IF< Named<T,E>::valid, bar_DE, bar_DF >::RET bar_t;
  bar_t::exec(d, t);
}



//
//  main
//
//////////////////////////////////////////////////////////////////////


int main() {
  D1 d;
  E1 e;
  bar(d,e);
}
