#include <iostream>
using std::cout;
using std::endl;

#include "exact_type.hh"


//
//  bounds and concrete classes
//
//////////////////////////////////////////////////////////////////////


template<class I = Bottom>
struct D : public Void< D<I> > {
protected: D() {}
};


template<class I = Bottom>
struct D1 : public D< D1<I> > {
};


template<class I = Bottom>
struct E : public Void< E<I> > {
protected: E() {}
};


template<class I = Bottom>
struct E1 : public E< E1<I> > {
};


template<class I = Bottom>
struct F : public Void< F<I> > {
protected: F() {}
};


template<class I = Bottom>
struct F1 : public F< F1<I> > {
};



//
//  overloaded functions
//
//////////////////////////////////////////////////////////////////////


template<class T, class U>
void bar(D<T>& d, E<U>& e) {
  cout << "bar(D,E)" << endl;
}


template<class T, class U>
void bar(D<T>& d, F<U>& f) {
  cout << "bar(D,F)" << endl;
}



//
//  main
//
//////////////////////////////////////////////////////////////////////


int main() {
  D1<> d;
  E1<> e;
  bar(d,e);
}
