#include <iostream>
using std::cout;
using std::endl;

#include "exact_type.hh"



//
//  reccurring hierarchy
//
//////////////////////////////////////////////////////////////////////


template<class I = Bottom>
struct A : public Void< A<I> > {
protected:
  A() {}
};


template<class I = Bottom>
struct B2 : public A< B2<I> > {
  void m() { cout << "B2::m" << endl; }
};


template<class I = Bottom>
struct B20 : public B2< B20<I> > {
  void m() { cout << "B20::m" << endl; }
};



//
//  foo'n bar
//
//////////////////////////////////////////////////////////////////////


template<class T>
void foo(A<T>& _a) {
  typedef typename exact< A<T> >::type A;
  A& a = to_exact(_a);
  // ...
  a.m();
}


template<class T>
void bar_with_upcast(B2<T>& b) {
  foo(b);
}



//
//  main
//
//////////////////////////////////////////////////////////////////////


int main() {
  B20<> b;
  foo(b);              // B20::m
  bar_with_upcast(b);  // B20::m
}
