
#include <iostream>
using std::cout;
using std::endl;

#include "exact_type.hh"


//
//  ``Vertical'' recurring hierarchy:
//
//   A*
//   |
//   B*
//   |
//   C*
//
//////////////////////////////////////////////////////////////////////


template<class I = Bottom>
class A : public Void< A<I> > {
public:
  void echo() {
    cout << "A" << endl;
  }
};


template<class I = Bottom>
class B : public A< B<I> > {
public:
  void echo() {
    cout << "B" << endl;
  }
};


template<class I = Bottom>
class C : public B< C<I> > {
public:
  void echo() {
    cout << "C" << endl;
  }
};



//
//  strong statically typed foo
//
//////////////////////////////////////////////////////////////////////


template<class T>
void foo(A<T>& a) {
  to_exact(a).echo();
}



//
//  main
//
//////////////////////////////////////////////////////////////////////


int main() {
  A<> a;  foo(a);
  B<> b;  foo(b);
  C<> c;  foo(c);
}
