/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.tools;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.java.plugin.ObjectFactory;
import org.java.plugin.PathResolver;
import org.java.plugin.registry.Identity;
import org.java.plugin.registry.ManifestProcessingException;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.registry.PluginFragment;
import org.java.plugin.registry.PluginRegistry;
import org.java.plugin.registry.Version;
import org.java.plugin.tools.Util;
import org.java.plugin.util.IoUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PluginArchiver {
    private static final String DESCRIPTOR_ENTRY_NAME = "JPF-DESCRIPTOR";

    public static void pack(PluginDescriptor descr, PathResolver pathResolver, File destFile) throws IOException {
        PluginArchiver.pack(pathResolver.resolvePath(descr, "/"), "JPF plug-in " + descr.getId() + " of version " + descr.getVersion(), destFile);
    }

    public static void pack(PluginFragment fragment, PathResolver pathResolver, File destFile) throws IOException {
        PluginArchiver.pack(pathResolver.resolvePath(fragment, "/"), "JPF plug-in fragment " + fragment.getId() + " of version " + fragment.getVersion(), destFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void pack(URL url, String comment, File destFile) throws IOException {
        ZipOutputStream zipStrm = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(destFile, false)));
        try {
            zipStrm.setComment(comment);
            File file = IoUtil.url2file(url);
            if (file == null) {
                throw new IOException("resolved URL " + url + " is not local file system location pointer");
            }
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                PluginArchiver.packEntry(zipStrm, null, files[i]);
            }
        }
        finally {
            zipStrm.close();
        }
    }

    public static Set<String> pack(PluginRegistry registry, PathResolver pathResolver, File destFile) throws IOException {
        return PluginArchiver.pack(registry, pathResolver, destFile, new Filter(){

            public boolean accept(String id, Version version, boolean isFragment) {
                return true;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> pack(PluginRegistry registry, PathResolver pathResolver, File destFile, Filter filter) throws IOException {
        Set<String> result;
        ZipOutputStream zipStrm = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(destFile, false)));
        try {
            int i;
            File[] files;
            File file;
            URL url;
            zipStrm.setComment("JPF plug-ins archive");
            ZipEntry entry = new ZipEntry(DESCRIPTOR_ENTRY_NAME);
            entry.setComment("JPF plug-ins archive descriptor");
            zipStrm.putNextEntry(entry);
            result = PluginArchiver.writeDescripor(registry, filter, new ObjectOutputStream(zipStrm));
            zipStrm.closeEntry();
            for (PluginDescriptor descr : registry.getPluginDescriptors()) {
                if (!result.contains(descr.getUniqueId())) continue;
                url = pathResolver.resolvePath(descr, "/");
                file = IoUtil.url2file(url);
                if (file == null) {
                    throw new IOException("resolved URL " + url + " is not local file system location pointer");
                }
                entry = new ZipEntry(descr.getUniqueId() + "/");
                entry.setComment("Content for JPF plug-in " + descr.getId() + " version " + descr.getVersion());
                entry.setTime(file.lastModified());
                zipStrm.putNextEntry(entry);
                files = file.listFiles();
                for (i = 0; i < files.length; ++i) {
                    PluginArchiver.packEntry(zipStrm, entry, files[i]);
                }
            }
            for (PluginFragment fragment : registry.getPluginFragments()) {
                if (!result.contains(fragment.getUniqueId())) continue;
                url = pathResolver.resolvePath(fragment, "/");
                file = IoUtil.url2file(url);
                if (file == null) {
                    throw new IOException("resolved URL " + url + " is not local file system location pointer");
                }
                entry = new ZipEntry(fragment.getUniqueId() + "/");
                entry.setComment("Content for JPF plug-in fragment " + fragment.getId() + " version " + fragment.getVersion());
                entry.setTime(file.lastModified());
                zipStrm.putNextEntry(entry);
                files = file.listFiles();
                for (i = 0; i < files.length; ++i) {
                    PluginArchiver.packEntry(zipStrm, entry, files[i]);
                }
            }
        }
        finally {
            zipStrm.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void packEntry(ZipOutputStream zipStrm, ZipEntry parentEntry, File file) throws IOException {
        String parentEntryName;
        String string = parentEntryName = parentEntry == null ? "" : parentEntry.getName();
        if (file.isFile()) {
            ZipEntry entry = new ZipEntry(parentEntryName + file.getName());
            entry.setTime(file.lastModified());
            zipStrm.putNextEntry(entry);
            BufferedInputStream fileStrm = new BufferedInputStream(new FileInputStream(file));
            try {
                IoUtil.copyStream(fileStrm, zipStrm, 1024);
            }
            finally {
                fileStrm.close();
            }
            return;
        }
        ZipEntry entry = new ZipEntry(parentEntryName + file.getName() + "/");
        entry.setTime(file.lastModified());
        zipStrm.putNextEntry(entry);
        File[] files = file.listFiles();
        for (int i = 0; i < files.length; ++i) {
            PluginArchiver.packEntry(zipStrm, entry, files[i]);
        }
    }

    public static Set<String> unpack(URL archiveFile, PluginRegistry registry, File destFolder) throws ManifestProcessingException, IOException, ClassNotFoundException {
        return PluginArchiver.unpack(archiveFile, registry, destFolder, new Filter(){

            public boolean accept(String id, Version version, boolean isFragment) {
                return true;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> unpack(URL archiveFile, PluginRegistry registry, File destFolder, Filter filter) throws IOException, ManifestProcessingException, ClassNotFoundException {
        Set<String> result;
        int count = 0;
        ZipInputStream zipStrm = new ZipInputStream(new BufferedInputStream(archiveFile.openStream()));
        try {
            ZipEntry entry = zipStrm.getNextEntry();
            if (entry == null) {
                throw new IOException("invalid plug-ins archive, no entries found");
            }
            if (!DESCRIPTOR_ENTRY_NAME.equals(entry.getName())) {
                throw new IOException("invalid plug-ins archive " + archiveFile + ", entry " + DESCRIPTOR_ENTRY_NAME + " not found as first ZIP entry in the archive file");
            }
            ObjectInputStream strm = new ObjectInputStream(zipStrm);
            result = PluginArchiver.readDescriptor(strm, registry, destFolder, filter);
            entry = zipStrm.getNextEntry();
            while (entry != null) {
                String name = entry.getName();
                if (name.endsWith("/") && name.lastIndexOf(47, name.length() - 2) == -1) {
                    String uid = name.substring(0, name.length() - 1);
                    if (!result.contains(uid)) {
                        entry = zipStrm.getNextEntry();
                        continue;
                    }
                    ++count;
                } else {
                    int p = name.indexOf(47);
                    if (p == -1 || p == 0 || !result.contains(name.substring(0, p))) {
                        entry = zipStrm.getNextEntry();
                        continue;
                    }
                }
                PluginArchiver.unpackEntry(zipStrm, entry, destFolder);
                entry = zipStrm.getNextEntry();
            }
        }
        finally {
            zipStrm.close();
        }
        if (result.size() != count) {
            throw new IOException("invalid plug-ins number (" + count + ") found in the archive, expected number according to " + "the archive descriptor is " + result.size());
        }
        return result;
    }

    public static Set<String> unpack(URL archiveFile, File destFolder) throws ManifestProcessingException, IOException, ClassNotFoundException {
        return PluginArchiver.unpack(archiveFile, ObjectFactory.newInstance().createRegistry(), destFolder);
    }

    public static Set<String> unpack(URL archiveFile, File destFolder, Filter filter) throws ManifestProcessingException, IOException, ClassNotFoundException {
        return PluginArchiver.unpack(archiveFile, ObjectFactory.newInstance().createRegistry(), destFolder, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unpackEntry(ZipInputStream zipStrm, ZipEntry entry, File destFolder) throws IOException {
        String name = entry.getName();
        if (name.endsWith("/")) {
            File folder = new File(destFolder.getCanonicalPath() + "/" + name);
            if (!folder.exists() && !folder.mkdirs()) {
                throw new IOException("can't create folder " + folder);
            }
            folder.setLastModified(entry.getTime());
            return;
        }
        File file = new File(destFolder.getCanonicalPath() + "/" + name);
        File folder = file.getParentFile();
        if (!folder.exists() && !folder.mkdirs()) {
            throw new IOException("can't create folder " + folder);
        }
        BufferedOutputStream strm = new BufferedOutputStream(new FileOutputStream(file, false));
        try {
            IoUtil.copyStream(zipStrm, strm, 1024);
        }
        finally {
            ((OutputStream)strm).close();
        }
        file.setLastModified(entry.getTime());
    }

    public static Set<String> readDescriptor(URL archiveFile, PluginRegistry registry) throws IOException, ClassNotFoundException, ManifestProcessingException {
        return PluginArchiver.readDescriptor(archiveFile, registry, new Filter(){

            public boolean accept(String id, Version version, boolean isFragment) {
                return true;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> readDescriptor(URL archiveFile, PluginRegistry registry, Filter filter) throws IOException, ClassNotFoundException, ManifestProcessingException {
        ZipInputStream zipStrm = new ZipInputStream(new BufferedInputStream(archiveFile.openStream()));
        try {
            ZipEntry entry = zipStrm.getNextEntry();
            if (entry == null) {
                throw new IOException("invalid plug-ins archive, no entries found");
            }
            if (!DESCRIPTOR_ENTRY_NAME.equals(entry.getName())) {
                throw new IOException("invalid plug-ins archive " + archiveFile + ", entry " + DESCRIPTOR_ENTRY_NAME + " not found as first ZIP entry in the archive file");
            }
            ObjectInputStream strm = new ObjectInputStream(zipStrm);
            Set<String> set = PluginArchiver.readDescriptor(strm, registry, Util.getTempFolder(), filter);
            return set;
        }
        finally {
            zipStrm.close();
        }
    }

    private static Set<String> writeDescripor(PluginRegistry registry, Filter filter, ObjectOutputStream strm) throws IOException {
        HashMap<String, ArchiveDescriptorEntry> result = new HashMap<String, ArchiveDescriptorEntry>();
        for (PluginDescriptor descr : registry.getPluginDescriptors()) {
            if (!filter.accept(descr.getId(), descr.getVersion(), false)) continue;
            result.put(descr.getUniqueId(), new ArchiveDescriptorEntry(descr.getId(), descr.getVersion(), false, Util.readUrlContent(descr.getLocation())));
        }
        for (PluginFragment fragment : registry.getPluginFragments()) {
            if (!filter.accept(fragment.getId(), fragment.getVersion(), true)) continue;
            result.put(fragment.getUniqueId(), new ArchiveDescriptorEntry(fragment.getId(), fragment.getVersion(), true, Util.readUrlContent(fragment.getLocation())));
        }
        strm.writeObject(result.values().toArray(new ArchiveDescriptorEntry[result.size()]));
        return result.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<String> readDescriptor(ObjectInputStream strm, PluginRegistry registry, File tempFolder, Filter filter) throws IOException, ClassNotFoundException, ManifestProcessingException {
        ArchiveDescriptorEntry[] data = (ArchiveDescriptorEntry[])strm.readObject();
        HashSet<URL> urls = new HashSet<URL>();
        HashSet<File> files = new HashSet<File>();
        for (int i = 0; i < data.length; ++i) {
            if (!filter.accept(data[i].getId(), data[i].getVersion(), data[i].isFragment())) continue;
            File file = File.createTempFile("manifest.", null, tempFolder);
            file.deleteOnExit();
            BufferedOutputStream fileStrm = new BufferedOutputStream(new FileOutputStream(file, false));
            try {
                ((OutputStream)fileStrm).write(data[i].getData());
            }
            finally {
                ((OutputStream)fileStrm).close();
            }
            files.add(file);
            urls.add(IoUtil.file2url(file));
        }
        HashSet<String> result = new HashSet<String>();
        try {
            for (Identity obj : registry.register(urls.toArray(new URL[urls.size()])).values()) {
                if (obj instanceof PluginDescriptor) {
                    result.add(((PluginDescriptor)obj).getUniqueId());
                    continue;
                }
                if (!(obj instanceof PluginFragment)) continue;
                result.add(((PluginFragment)obj).getUniqueId());
            }
        }
        finally {
            for (File file : files) {
                file.delete();
            }
        }
        return result;
    }

    private PluginArchiver() {
    }

    private static class ArchiveDescriptorEntry
    implements Serializable {
        private static final long serialVersionUID = 8749937247555974932L;
        private final String id;
        private final Version version;
        private final boolean isFragment;
        private final byte[] data;

        protected ArchiveDescriptorEntry(String anId, Version aVersion, boolean fragment, byte[] aData) {
            this.id = anId;
            this.version = aVersion;
            this.isFragment = fragment;
            this.data = aData;
        }

        protected String getId() {
            return this.id;
        }

        protected Version getVersion() {
            return this.version;
        }

        protected boolean isFragment() {
            return this.isFragment;
        }

        protected byte[] getData() {
            return this.data;
        }
    }

    public static interface Filter {
        public boolean accept(String var1, Version var2, boolean var3);
    }
}

