/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.tools.ant;

import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.registry.PluginFragment;
import org.java.plugin.tools.PluginArchiver;
import org.java.plugin.tools.ant.BaseJpfTask;

public class SingleFilePluginTask
extends BaseJpfTask {
    private File destDir;

    public void setDestDir(File aDestDir) {
        this.destDir = aDestDir;
    }

    public void execute() throws BuildException {
        File destFile;
        if (this.destDir == null) {
            throw new BuildException("destdir attribute must be set!", this.getLocation());
        }
        this.initRegistry(true);
        int count = 0;
        for (PluginDescriptor descr : this.getRegistry().getPluginDescriptors()) {
            destFile = new File(this.destDir, descr.getId() + "-" + descr.getVersion() + ".zip");
            try {
                PluginArchiver.pack(descr, this.getPathResolver(), destFile);
            }
            catch (IOException ioe) {
                throw new BuildException("failed building plug-in file " + destFile, (Throwable)ioe, this.getLocation());
            }
            if (this.getVerbose()) {
                this.log("Created plug-in file " + destFile);
            }
            ++count;
        }
        for (PluginFragment fragment : this.getRegistry().getPluginFragments()) {
            destFile = new File(this.destDir, fragment.getId() + "-" + fragment.getVersion() + ".zip");
            try {
                PluginArchiver.pack(fragment, this.getPathResolver(), destFile);
            }
            catch (IOException ioe) {
                throw new BuildException("failed building plug-in fragment file " + destFile, (Throwable)ioe, this.getLocation());
            }
            if (this.getVerbose()) {
                this.log("Created plug-in fragment file " + destFile);
            }
            ++count;
        }
        this.log("Plug-in files created " + count);
    }
}

