/*
 * Decompiled with CFR 0.152.
 */
package jhoafparser.transformations;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import jhoafparser.consumer.HOAConsumerException;
import jhoafparser.storage.StoredAutomaton;
import jhoafparser.storage.StoredAutomatonManipulator;
import jhoafparser.storage.StoredEdgeImplicit;
import jhoafparser.storage.StoredEdgeWithLabel;
import jhoafparser.storage.StoredState;
import jhoafparser.storage.UniqueTable;

public class ToStateAcceptance
implements StoredAutomatonManipulator {
    private boolean skipIfAlreadyStateBased = true;
    private StoredAutomaton source;
    private StoredAutomaton target;
    private UniqueTable<BitSet> acceptanceSignatures = new UniqueTable();
    private HashMap<StateWithAcceptance, Integer> transformedStates = new HashMap();
    private TreeMap<Integer, StateWithAcceptance> statesForOutput = new TreeMap();
    private boolean debug = false;

    public ToStateAcceptance() {
    }

    private ToStateAcceptance(StoredAutomaton source) {
        this.source = source;
        this.target = new StoredAutomaton();
    }

    private void handleHeader() {
        this.target.setStoredHeader(this.source.getStoredHeader().clone());
        this.handleProperties();
        this.target.getStoredHeader().getMiscHeaders().clear();
    }

    private void handleProperties() {
        Iterator<String> it = this.target.getStoredHeader().getProperties().iterator();
        block24: while (it.hasNext()) {
            String property;
            switch (property = it.next()) {
                case "trans-acc": {
                    it.remove();
                    continue block24;
                }
                case "state-acc": {
                    continue block24;
                }
                case "state-labels": 
                case "trans-labels": 
                case "implicit-labels": 
                case "explicit-labels": 
                case "univ-branch": 
                case "no-univ-branch": 
                case "deterministic": 
                case "complete": 
                case "unambiguous": 
                case "stutter-invariant": 
                case "weak": 
                case "very-weak": 
                case "inherently-weak": 
                case "terminal": 
                case "tight": {
                    continue block24;
                }
            }
            it.remove();
        }
        this.target.getStoredHeader().getProperties().add("state-acc");
    }

    private void handleStartStates() {
        this.target.getStoredHeader().getStartStates().clear();
        for (List<Integer> start : this.source.getStoredHeader().getStartStates()) {
            ArrayList<Integer> transformed = new ArrayList<Integer>();
            for (Integer s : start) {
                transformed.add(this.handleState(s, new BitSet()));
            }
            this.target.getStoredHeader().addStartStates(transformed);
        }
    }

    private void transformTransitionStructure() throws HOAConsumerException {
        while (!this.statesForOutput.isEmpty()) {
            List<Integer> conjSuccessors;
            Map.Entry<Integer, StateWithAcceptance> e = this.statesForOutput.firstEntry();
            this.statesForOutput.remove(e.getKey());
            Integer stateId = e.getKey();
            StateWithAcceptance sTransformed = e.getValue();
            StoredState s = this.source.getStoredState(sTransformed.originalStateId);
            String info = null;
            info = this.debug ? sTransformed.toString() : s.getInfo();
            this.target.addState(new StoredState(stateId, info, s.getLabelExpr(), this.bitSetToAccSignature(sTransformed.acceptanceSignature)));
            List<Integer> accSignatureState = this.source.getStoredState(sTransformed.originalStateId).getAccSignature();
            if (this.source.hasEdgesImplicit(sTransformed.originalStateId)) {
                if (this.source.hasEdgesWithLabel(sTransformed.originalStateId)) {
                    throw new HOAConsumerException("Mixed explicit and implicit edges");
                }
                for (StoredEdgeImplicit storedEdgeImplicit : this.source.getEdgesImplicit(sTransformed.originalStateId)) {
                    conjSuccessors = this.transformSuccessors(storedEdgeImplicit.getConjSuccessors(), accSignatureState, storedEdgeImplicit.getAccSignature());
                    this.target.addEdgeImplicit(stateId, new StoredEdgeImplicit(conjSuccessors, null));
                }
                continue;
            }
            if (this.source.hasEdgesWithLabel(sTransformed.originalStateId)) {
                for (StoredEdgeWithLabel storedEdgeWithLabel : this.source.getEdgesWithLabel(sTransformed.originalStateId)) {
                    conjSuccessors = this.transformSuccessors(storedEdgeWithLabel.getConjSuccessors(), accSignatureState, storedEdgeWithLabel.getAccSignature());
                    this.target.addEdgeWithLabel(stateId, new StoredEdgeWithLabel(storedEdgeWithLabel.getLabelExpr(), conjSuccessors, null));
                }
                continue;
            }
            throw new UnsupportedOperationException("State without outgoing edges");
        }
    }

    private List<Integer> transformSuccessors(List<Integer> conjSuccessors, List<Integer> accSignatureState, List<Integer> accSignatureEdge) throws HOAConsumerException {
        List<Integer> accSignature;
        if (accSignatureState != null && accSignatureEdge != null) {
            accSignature = new ArrayList<Integer>(accSignatureState);
            accSignature.addAll(accSignatureEdge);
        } else {
            accSignature = accSignatureEdge != null ? accSignatureEdge : accSignatureState;
        }
        BitSet acceptanceSignature = this.accSignatureToBitSet(accSignature);
        ArrayList<Integer> transformed = new ArrayList<Integer>(conjSuccessors.size());
        for (Integer successor : conjSuccessors) {
            transformed.add(this.handleState(successor, acceptanceSignature));
        }
        return transformed;
    }

    private Integer handleState(Integer stateId, BitSet accSignature) {
        StateWithAcceptance sTransformed = new StateWithAcceptance(stateId, accSignature);
        Integer id = this.transformedStates.get(sTransformed);
        if (id == null) {
            id = this.transformedStates.size();
            this.transformedStates.put(sTransformed, id);
            this.statesForOutput.put(id, sTransformed);
        }
        return id;
    }

    private BitSet accSignatureToBitSet(List<Integer> accSignature) {
        BitSet result = new BitSet();
        if (accSignature != null) {
            for (Integer i : accSignature) {
                result.set(i);
            }
        }
        return this.acceptanceSignatures.findOrAdd(result);
    }

    private List<Integer> bitSetToAccSignature(BitSet accSignature) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        Integer i = accSignature.nextSetBit(0);
        while (i >= 0) {
            list.add(i);
            i = accSignature.nextSetBit(i + 1);
        }
        return list;
    }

    private boolean hasTransitionAcceptance() {
        int numStates = this.source.getNumberOfStates();
        for (int state = 0; state <= numStates; ++state) {
            if (this.source.hasEdgesImplicit(state)) {
                for (StoredEdgeImplicit storedEdgeImplicit : this.source.getEdgesImplicit(state)) {
                    if (storedEdgeImplicit.getAccSignature() == null || storedEdgeImplicit.getAccSignature().isEmpty()) continue;
                    return true;
                }
            }
            if (!this.source.hasEdgesWithLabel(state)) continue;
            for (StoredEdgeWithLabel storedEdgeWithLabel : this.source.getEdgesWithLabel(state)) {
                if (storedEdgeWithLabel.getAccSignature() == null || storedEdgeWithLabel.getAccSignature().isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    private StoredAutomaton transform() throws HOAConsumerException {
        if (this.skipIfAlreadyStateBased && !this.hasTransitionAcceptance()) {
            this.source.getStoredHeader().getProperties().remove("trans-acc");
            this.source.getStoredHeader().getProperties().add("state-acc");
            return this.source;
        }
        this.handleHeader();
        this.handleStartStates();
        this.transformTransitionStructure();
        this.target.getStoredHeader().setNumberOfStates(this.target.getNumberOfStates());
        return this.target;
    }

    @Override
    public StoredAutomaton manipulate(StoredAutomaton aut) throws HOAConsumerException {
        ToStateAcceptance transform = new ToStateAcceptance(aut);
        return transform.transform();
    }

    private static class StateWithAcceptance {
        public Integer originalStateId;
        public BitSet acceptanceSignature;

        public StateWithAcceptance(Integer originalStateId, BitSet acceptanceSignature) {
            this.originalStateId = originalStateId;
            this.acceptanceSignature = acceptanceSignature;
        }

        public String toString() {
            return this.originalStateId + " " + this.acceptanceSignature;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.acceptanceSignature == null ? 0 : this.acceptanceSignature.hashCode());
            result = 31 * result + (this.originalStateId == null ? 0 : this.originalStateId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof StateWithAcceptance)) {
                return false;
            }
            StateWithAcceptance other = (StateWithAcceptance)obj;
            if (this.acceptanceSignature == null ? other.acceptanceSignature != null : !this.acceptanceSignature.equals(other.acceptanceSignature)) {
                return false;
            }
            return !(this.originalStateId == null ? other.originalStateId != null : !this.originalStateId.equals(other.originalStateId));
        }
    }
}

