/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.transformations;

import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.BitSet;
import java.util.List;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntUnaryOperator;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import owl.automaton.Automaton;
import owl.automaton.AutomatonFactory;
import owl.automaton.AutomatonUtil;
import owl.automaton.MutableAutomaton;
import owl.automaton.MutableAutomatonFactory;
import owl.automaton.MutableAutomatonUtil;
import owl.automaton.acceptance.ParityAcceptance;
import owl.automaton.algorithms.SccDecomposition;
import owl.automaton.edge.Edge;
import owl.automaton.minimizations.GenericMinimizations;
import owl.run.modules.ImmutableTransformerParser;
import owl.run.modules.OwlModuleParser;

public final class ParityUtil {
    public static final OwlModuleParser.TransformerParser COMPLEMENT_CLI = ImmutableTransformerParser.builder().key("complement-parity").description("Complements a parity automaton").parser(settings -> environment -> (input, context) -> {
        Automaton<Object, ParityAcceptance> automaton = AutomatonUtil.cast(input, ParityAcceptance.class);
        return ParityUtil.complement(MutableAutomatonUtil.asMutable(automaton), MutableAutomatonUtil.Sink.INSTANCE);
    }).build();
    public static final OwlModuleParser.TransformerParser CONVERSION_CLI = ImmutableTransformerParser.builder().key("convert-parity").optionsDirect(new Options().addOptionGroup(new OptionGroup().addOption(new Option(null, "max", false, null)).addOption(new Option(null, "min", false, null))).addOptionGroup(new OptionGroup().addOption(new Option(null, "even", false, null)).addOption(new Option(null, "odd", false, null)))).description("Converts a parity automaton into the desired type").parser(settings -> {
        Boolean toMax = settings.hasOption("max") ? Boolean.TRUE : (settings.hasOption("min") ? Boolean.FALSE : null);
        Boolean toEven = settings.hasOption("even") ? Boolean.TRUE : (settings.hasOption("odd") ? Boolean.FALSE : null);
        return environment -> (input, context) -> {
            Automaton<Object, ParityAcceptance> automaton = AutomatonUtil.cast(input, ParityAcceptance.class);
            ParityAcceptance acceptance = automaton.acceptance();
            ParityAcceptance.Parity target = acceptance.parity();
            if (toEven != null) {
                target = target.setEven(toEven);
            }
            if (toMax != null) {
                target = target.setMax(toMax);
            }
            return ParityUtil.convert(automaton, target);
        };
    }).build();

    private ParityUtil() {
    }

    public static <S> MutableAutomaton<S, ParityAcceptance> complement(MutableAutomaton<S, ParityAcceptance> automaton, S sinkState) {
        assert (automaton.is(Automaton.Property.DETERMINISTIC));
        ParityAcceptance acceptance = (ParityAcceptance)automaton.acceptance();
        if (acceptance.acceptanceSets() == 0 && !acceptance.emptyIsAccepting()) {
            return MutableAutomatonFactory.copy(AutomatonFactory.singleton(automaton.factory(), sinkState, acceptance.complement(), new BitSet()));
        }
        if (acceptance.acceptanceSets() <= 1) {
            acceptance = acceptance.withAcceptanceSets(2);
            automaton.acceptance(acceptance);
        }
        MutableAutomatonUtil.complete(automaton, sinkState);
        automaton.acceptance(acceptance.complement());
        return automaton;
    }

    public static <S> MutableAutomaton<S, ParityAcceptance> minimizePriorities(MutableAutomaton<S, ParityAcceptance> automaton) {
        GenericMinimizations.removeTransientAcceptance(automaton);
        return ParityUtil.minimizePriorities(automaton, SccDecomposition.computeSccs(automaton, false));
    }

    private static <S> MutableAutomaton<S, ParityAcceptance> minimizePriorities(MutableAutomaton<S, ParityAcceptance> automaton, List<Set<S>> sccs) {
        ParityAcceptance acceptance = (ParityAcceptance)automaton.acceptance();
        int acceptanceSets = acceptance.acceptanceSets();
        BitSet globallyUsedPriorities = new BitSet(acceptanceSets);
        Int2IntOpenHashMap reductionMapping = new Int2IntOpenHashMap();
        reductionMapping.defaultReturnValue(-1);
        BitSet usedPriorities = new BitSet(acceptanceSets);
        int usedAcceptanceSets = 0;
        for (Set<S> scc : sccs) {
            reductionMapping.clear();
            usedPriorities.clear();
            for (S state : scc) {
                for (Edge<S> edge : automaton.edges(state)) {
                    PrimitiveIterator.OfInt acceptanceSetIterator;
                    if (!scc.contains(edge.successor()) || !(acceptanceSetIterator = edge.acceptanceSetIterator()).hasNext()) continue;
                    usedPriorities.set(acceptanceSetIterator.nextInt());
                }
            }
            if (usedPriorities.cardinality() == acceptanceSets) {
                usedAcceptanceSets = Math.max(usedAcceptanceSets, acceptanceSets);
                continue;
            }
            int currentPriority = usedPriorities.nextSetBit(0);
            int currentTarget = currentPriority % 2;
            while (currentPriority != -1) {
                if (currentTarget % 2 != currentPriority % 2) {
                    ++currentTarget;
                }
                reductionMapping.put(currentPriority, currentTarget);
                globallyUsedPriorities.set(currentTarget);
                usedAcceptanceSets = Math.max(usedAcceptanceSets, currentTarget + 1);
                currentPriority = usedPriorities.nextSetBit(currentPriority + 1);
            }
            automaton.updateEdges(scc, (arg_0, arg_1) -> ParityUtil.lambda$minimizePriorities$6((Int2IntMap)reductionMapping, arg_0, arg_1));
            automaton.trim();
        }
        automaton.acceptance(acceptance.withAcceptanceSets(usedAcceptanceSets));
        return automaton;
    }

    public static <S> Automaton<S, ParityAcceptance> convert(Automaton<S, ParityAcceptance> automaton, ParityAcceptance.Parity toParity) {
        ParityAcceptance acceptance = automaton.acceptance();
        if (acceptance.parity().equals((Object)toParity)) {
            return automaton;
        }
        IntUnaryOperator mapping = ParityUtil.getEdgeMapping(acceptance, toParity);
        MutableAutomaton<Object, ParityAcceptance> mutable = MutableAutomatonUtil.asMutable(automaton);
        AtomicInteger maximalNewAcceptance = new AtomicInteger(0);
        mutable.updateEdges((state, edge) -> {
            if (!edge.hasAcceptanceSets()) {
                return edge;
            }
            int newAcceptance = mapping.applyAsInt(edge.smallestAcceptanceSet());
            if (newAcceptance == -1) {
                return Edge.of(edge.successor());
            }
            if (maximalNewAcceptance.get() < newAcceptance) {
                maximalNewAcceptance.set(newAcceptance);
            }
            return edge.withAcceptance(newAcceptance);
        });
        mutable.trim();
        mutable.acceptance(new ParityAcceptance(maximalNewAcceptance.get() + 1, toParity));
        return mutable;
    }

    private static IntUnaryOperator getEdgeMapping(ParityAcceptance fromAcceptance, ParityAcceptance.Parity toParity) {
        int leastImportantColor;
        ParityAcceptance.Parity fromParity = fromAcceptance.parity();
        if (fromParity.max() == toParity.max()) {
            assert (fromParity.even() != toParity.even());
            return i -> i + 1;
        }
        int acceptanceSets = fromAcceptance.acceptanceSets();
        int n = leastImportantColor = fromParity.max() ? 0 : acceptanceSets - 1;
        int offset = fromParity.even() == toParity.even() ? (fromAcceptance.isAccepting(leastImportantColor) ? 0 : 1) : (fromAcceptance.isAccepting(leastImportantColor) ? -1 : -2);
        int newAcceptanceSets = acceptanceSets + offset;
        return i -> newAcceptanceSets - i;
    }

    private static /* synthetic */ Edge lambda$minimizePriorities$6(Int2IntMap reductionMapping, Object state, Edge edge) {
        return edge.withAcceptance((IntUnaryOperator)reductionMapping);
    }
}

