/*
 * Decompiled with CFR 0.152.
 */
package owl.ltl;

import java.util.BitSet;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nonnegative;
import owl.ltl.AbstractFormula;
import owl.ltl.BooleanConstant;
import owl.ltl.Formula;
import owl.ltl.visitors.BinaryVisitor;
import owl.ltl.visitors.IntVisitor;
import owl.ltl.visitors.Visitor;

public final class Literal
extends AbstractFormula {
    private final int index;
    private final Literal negation;

    public static Literal of(int index, boolean negate) {
        return new Literal(index, negate);
    }

    private Literal(Literal other) {
        this.negation = other;
        this.index = -other.index;
        assert (this.getAtom() == other.getAtom() && this.isNegated() ^ other.isNegated());
    }

    public Literal(@Nonnegative int index) {
        this(index, false);
    }

    public Literal(@Nonnegative int index, boolean negate) {
        Objects.checkIndex(index, Integer.MAX_VALUE);
        this.index = negate ? -(index + 1) : index + 1;
        this.negation = new Literal(this);
    }

    @Override
    public int accept(IntVisitor v) {
        return v.visit(this);
    }

    @Override
    public <R> R accept(Visitor<R> v) {
        return v.visit(this);
    }

    public <A, B> A accept(BinaryVisitor<B, A> v, B parameter) {
        return v.visit(this, parameter);
    }

    @Override
    public boolean allMatch(Predicate<Formula> predicate) {
        return predicate.test(this);
    }

    @Override
    public boolean anyMatch(Predicate<Formula> predicate) {
        return predicate.test(this);
    }

    @Override
    protected boolean equals2(AbstractFormula o) {
        Literal literal = (Literal)o;
        return this.index == literal.index;
    }

    public int getAtom() {
        return Math.abs(this.index) - 1;
    }

    @Override
    protected int hashCodeOnce() {
        return Integer.hashCode(this.index);
    }

    public boolean isNegated() {
        return this.index < 0;
    }

    @Override
    public boolean isPureEventual() {
        return false;
    }

    @Override
    public boolean isPureUniversal() {
        return false;
    }

    @Override
    public boolean isSuspendable() {
        return false;
    }

    @Override
    public Formula nnf() {
        return this;
    }

    @Override
    public Literal not() {
        return this.negation;
    }

    @Override
    public Formula temporalStep(BitSet valuation) {
        return BooleanConstant.of(valuation.get(this.getAtom()) ^ this.isNegated());
    }

    @Override
    public Formula temporalStepUnfold(BitSet valuation) {
        return this.temporalStep(valuation);
    }

    public String toString() {
        return this.isNegated() ? "!p" + (-this.index - 1) : "p" + (this.index - 1);
    }

    @Override
    public Formula unfold() {
        return this;
    }

    @Override
    public Formula unfoldTemporalStep(BitSet valuation) {
        return this.temporalStep(valuation);
    }
}

