/*
 * Decompiled with CFR 0.152.
 */
package owl.run.parser;

import com.google.common.base.Preconditions;
import java.util.function.Function;
import owl.run.modules.OwlModule;
import owl.run.modules.OwlModuleParser;

abstract class Wrapper {
    Wrapper() {
    }

    static <T extends OwlModule> Wrapper module(T module) {
        Preconditions.checkNotNull(module);
        return new ModuleWrapper<T>(module);
    }

    static <T extends OwlModuleParser<?>> Wrapper settings(T settings) {
        Preconditions.checkNotNull(settings);
        return new SettingsWrapper<T>(settings);
    }

    abstract <V> V map(Function<OwlModule, V> var1, Function<OwlModuleParser<?>, V> var2);

    private static final class SettingsWrapper<T extends OwlModuleParser<?>>
    extends Wrapper {
        final T settings;

        SettingsWrapper(T settings) {
            this.settings = settings;
        }

        @Override
        public <V> V map(Function<OwlModule, V> moduleFun, Function<OwlModuleParser<?>, V> settingsFun) {
            return settingsFun.apply((OwlModuleParser<?>)this.settings);
        }
    }

    private static final class ModuleWrapper<T extends OwlModule>
    extends Wrapper {
        final T module;

        ModuleWrapper(T module) {
            this.module = module;
        }

        @Override
        public <V> V map(Function<OwlModule, V> moduleFun, Function<OwlModuleParser<?>, V> settingsFun) {
            return moduleFun.apply((OwlModule)this.module);
        }
    }
}

