/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.ltl2ldba;

import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import owl.automaton.Automaton;
import owl.automaton.AutomatonFactory;
import owl.automaton.MutableAutomaton;
import owl.automaton.MutableAutomatonFactory;
import owl.automaton.acceptance.NoneAcceptance;
import owl.automaton.edge.Edge;
import owl.automaton.edge.LabelledEdge;
import owl.automaton.ldba.MutableAutomatonBuilder;
import owl.collections.ValuationSet;
import owl.factories.Factories;
import owl.ltl.EquivalenceClass;
import owl.translations.ltl2ldba.AbstractJumpManager;
import owl.translations.ltl2ldba.AnalysisResult;
import owl.translations.ltl2ldba.EquivalenceClassStateFactory;
import owl.translations.ltl2ldba.Jump;
import owl.translations.ltl2ldba.LTL2LDBAFunction;
import owl.translations.ltl2ldba.RecurringObligation;

class InitialComponentBuilder<K extends RecurringObligation>
implements MutableAutomatonBuilder<EquivalenceClass, EquivalenceClass, NoneAcceptance> {
    private final boolean constructDeterministic;
    private final Deque<EquivalenceClass> constructionQueue;
    private final Factories factories;
    private final EquivalenceClassStateFactory factory;
    private final AbstractJumpManager<K> jumpFactory;
    private final SetMultimap<EquivalenceClass, Jump<K>> jumps;
    private final Set<EquivalenceClass> patientStates;

    InitialComponentBuilder(Factories factories, Set<LTL2LDBAFunction.Configuration> configuration, AbstractJumpManager<K> jumpFactory) {
        this.factories = factories;
        this.jumpFactory = jumpFactory;
        this.factory = new EquivalenceClassStateFactory(factories, configuration);
        this.constructionQueue = new ArrayDeque<EquivalenceClass>();
        this.constructDeterministic = !configuration.contains((Object)LTL2LDBAFunction.Configuration.NON_DETERMINISTIC_INITIAL_COMPONENT);
        this.jumps = MultimapBuilder.hashKeys().hashSetValues().build();
        this.patientStates = new HashSet<EquivalenceClass>();
    }

    @Override
    @Nullable
    public EquivalenceClass add(EquivalenceClass initialClass) {
        if (initialClass.isFalse()) {
            return null;
        }
        EquivalenceClass state = this.factory.getInitial(initialClass, new EquivalenceClass[0]);
        this.constructionQueue.add(state);
        return state;
    }

    @Override
    public MutableAutomaton<EquivalenceClass, NoneAcceptance> build() {
        if (this.constructDeterministic) {
            Automaton<EquivalenceClass, NoneAcceptance> automaton = AutomatonFactory.create(this.factories.vsFactory, this.constructionQueue, NoneAcceptance.INSTANCE, this::getDeterministicSuccessor);
            assert (automaton.is(Automaton.Property.DETERMINISTIC));
            return MutableAutomatonFactory.copy(automaton);
        }
        return MutableAutomatonFactory.create(NoneAcceptance.INSTANCE, this.factories.vsFactory, this.constructionQueue, this::getNondeterministicSuccessors);
    }

    private void generateJumps(EquivalenceClass state) {
        if (this.jumps.containsKey((Object)state)) {
            return;
        }
        AnalysisResult<K> result = this.jumpFactory.analyse(state);
        this.jumps.putAll((Object)state, result.jumps);
        if (result.type == AnalysisResult.TYPE.MAY) {
            this.patientStates.add(state);
        }
    }

    private List<LabelledEdge<EquivalenceClass>> getDeterministicSuccessor(EquivalenceClass state) {
        this.generateJumps(state);
        if (!this.patientStates.contains(state)) {
            return List.of();
        }
        Map<EquivalenceClass, ValuationSet> successors = this.factory.getSuccessors(state);
        assert (successors.entrySet().stream().noneMatch(x -> ((EquivalenceClass)x.getKey()).isFalse()));
        ArrayList<LabelledEdge<EquivalenceClass>> edges = new ArrayList<LabelledEdge<EquivalenceClass>>(successors.size());
        successors.forEach((successor, set) -> edges.add(LabelledEdge.of(successor, set)));
        return edges;
    }

    Set<Jump<K>> getJumps(EquivalenceClass state) {
        return this.jumps.get((Object)state);
    }

    private List<Edge<EquivalenceClass>> getNondeterministicSuccessors(EquivalenceClass state, BitSet valuation) {
        EquivalenceClass successorClass = this.factory.getNondeterministicSuccessor(state, valuation);
        this.generateJumps(state);
        if (successorClass.isTrue()) {
            return List.of(Edge.of(successorClass, 0));
        }
        if (successorClass.isFalse() || !this.patientStates.contains(state)) {
            return List.of();
        }
        ArrayList<Edge<EquivalenceClass>> successors = new ArrayList<Edge<EquivalenceClass>>();
        this.factory.splitEquivalenceClass(successorClass).forEach(x -> successors.add(Edge.of(x)));
        return successors;
    }
}

