/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.ltl2ldba;

import java.util.EnumSet;
import org.apache.commons.cli.CommandLine;
import owl.ltl.LabelledFormula;
import owl.run.modules.InputReaders;
import owl.run.modules.OutputWriters;
import owl.run.modules.Transformer;
import owl.run.modules.Transformers;
import owl.run.parser.PartialConfigurationParser;
import owl.run.parser.PartialModuleConfiguration;
import owl.translations.ltl2ldba.AbstractLTL2LDBAModule;
import owl.translations.ltl2ldba.LTL2LDBAFunction;

public final class LTL2LDGBAModule
extends AbstractLTL2LDBAModule {
    public static final LTL2LDGBAModule INSTANCE = new LTL2LDGBAModule();

    private LTL2LDGBAModule() {
    }

    public static void main(String ... args) {
        PartialConfigurationParser.run(args, PartialModuleConfiguration.builder(INSTANCE.getKey()).reader(InputReaders.LTL).addTransformer(Transformers.LTL_SIMPLIFIER).addTransformer(INSTANCE).writer(OutputWriters.HOA).build());
    }

    @Override
    public Transformer parse(CommandLine commandLine) {
        EnumSet<LTL2LDBAFunction.Configuration> configuration = LTL2LDGBAModule.configuration(commandLine);
        if (commandLine.hasOption(LTL2LDGBAModule.guessF().getOpt())) {
            return environment -> Transformers.instanceFromFunction(LabelledFormula.class, LTL2LDBAFunction.createGeneralizedBreakpointFreeLDBABuilder(environment, configuration));
        }
        return environment -> Transformers.instanceFromFunction(LabelledFormula.class, LTL2LDBAFunction.createGeneralizedBreakpointLDBABuilder(environment, configuration));
    }

    @Override
    public String getKey() {
        return "ltl2ldgba";
    }

    @Override
    public String getDescription() {
        return "Translates LTL to limit-deterministic generalized B\u00fcchi automata";
    }
}

