/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.ltl2ldba.breakpoint;

import com.google.common.collect.Sets;
import de.tum.in.naturals.bitset.BitSets;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import owl.factories.EquivalenceClassFactory;
import owl.ltl.BooleanConstant;
import owl.ltl.EquivalenceClass;
import owl.ltl.Formula;
import owl.ltl.GOperator;
import owl.ltl.SyntacticFragment;
import owl.ltl.visitors.Collector;
import owl.translations.ltl2ldba.AbstractJumpManager;
import owl.translations.ltl2ldba.FGSubstitution;
import owl.translations.ltl2ldba.Jump;
import owl.translations.ltl2ldba.LTL2LDBAFunction;
import owl.translations.ltl2ldba.breakpoint.GObligations;

public final class GObligationsJumpManager
extends AbstractJumpManager<GObligations> {
    private static final Logger logger = Logger.getLogger(GObligationsJumpManager.class.getName());
    private final Set<GObligations> obligations;

    private GObligationsJumpManager(EquivalenceClassFactory factory, Set<LTL2LDBAFunction.Configuration> optimisations, Set<GObligations> obligations, Set<Formula> modalOperators, Formula initialFormula) {
        super(optimisations, factory, modalOperators, initialFormula);
        this.obligations = Set.copyOf(obligations);
        logger.log(Level.FINE, () -> "The automaton has the following jumps: " + obligations);
    }

    public static GObligationsJumpManager build(Formula formula, EquivalenceClassFactory factory, Set<LTL2LDBAFunction.Configuration> optimisations) {
        EquivalenceClass initialState;
        block3: {
            block2: {
                initialState = factory.of(formula);
                Set<Formula> modalOperators = initialState.modalOperators();
                if (modalOperators.stream().allMatch(SyntacticFragment.CO_SAFETY::contains)) break block2;
                if (!modalOperators.stream().allMatch(SyntacticFragment.SAFETY::contains)) break block3;
            }
            return new GObligationsJumpManager(initialState.factory(), optimisations, Set.of(), Set.of(), BooleanConstant.TRUE);
        }
        Set<GObligations> jumps = GObligationsJumpManager.createDisjunctionStream(initialState, GObligationsJumpManager::createGSetStream).map(Gs -> GObligations.build(Gs, initialState.factory(), optimisations)).filter(Objects::nonNull).collect(Collectors.toUnmodifiableSet());
        return new GObligationsJumpManager(initialState.factory(), optimisations, jumps, initialState.modalOperators(), formula);
    }

    private static Stream<Set<GOperator>> createGSetStream(Formula formula) {
        return Sets.powerSet(Collector.collectTransformedGOperators(formula)).stream();
    }

    private static boolean dependsOnExternalAtoms(EquivalenceClass remainder, GObligations obligation) {
        BitSet remainderAP = remainder.atomicPropositions();
        remainderAP.or(Collector.collectAtoms(remainder.modalOperators()));
        BitSet obligationAP = Collector.collectAtoms(obligation.gOperatorsRewritten());
        assert (!remainderAP.isEmpty());
        assert (!obligationAP.isEmpty());
        return !remainderAP.intersects(obligationAP);
    }

    @Override
    protected Set<Jump<GObligations>> computeJumps(EquivalenceClass state) {
        EquivalenceClass state2 = this.configuration.contains((Object)LTL2LDBAFunction.Configuration.EAGER_UNFOLD) ? state : state.unfold();
        HashSet<GObligations> availableObligations = new HashSet<GObligations>();
        for (GObligations x2 : this.obligations) {
            BitSet obligationAtoms = Collector.collectAtoms(x2.gOperators());
            BitSet supportAtoms = Collector.collectAtoms(state2.modalOperators());
            supportAtoms.or(state2.atomicPropositions());
            if (!BitSets.isSubset((BitSet)obligationAtoms, (BitSet)supportAtoms)) continue;
            availableObligations.add(x2);
        }
        HashSet<Jump<GObligations>> jumps = new HashSet<Jump<GObligations>>();
        for (GObligations obligation : availableObligations) {
            FGSubstitution evaluateVisitor = new FGSubstitution((Iterable<? extends Formula>)obligation.gOperators());
            EquivalenceClass remainder = state.substitute(x -> x.accept(evaluateVisitor));
            if (remainder.isFalse()) continue;
            if (obligation.getObligation().implies(remainder)) {
                jumps.add(this.buildJump(this.factory.getTrue(), obligation));
                continue;
            }
            if (this.configuration.contains((Object)LTL2LDBAFunction.Configuration.SUPPRESS_JUMPS) && GObligationsJumpManager.dependsOnExternalAtoms(remainder, obligation)) continue;
            jumps.add(this.buildJump(remainder, obligation));
        }
        return jumps;
    }
}

