/*
 * Decompiled with CFR 0.152.
 */
package owl.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;

public final class GuardedStream {
    public static final Writer syserr = GuardedStream.guard(new OutputStreamWriter((OutputStream)System.err, StandardCharsets.UTF_8));
    public static final OutputStream sysout = GuardedStream.guard(System.out);

    private GuardedStream() {
    }

    public static Writer guard(Writer writer) {
        return new SafeWriter(writer);
    }

    public static OutputStream guard(OutputStream stream) {
        return new SafeOutputStream(stream);
    }

    private static final class SafeOutputStream
    extends OutputStream {
        private final OutputStream delegate;

        SafeOutputStream(OutputStream delegate) {
            this.delegate = delegate;
        }

        @Override
        public void write(int b) throws IOException {
            this.delegate.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.delegate.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.delegate.write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            this.delegate.flush();
        }

        @Override
        public void close() throws IOException {
            this.delegate.flush();
        }
    }

    private static final class SafeWriter
    extends Writer {
        private final Writer delegate;

        SafeWriter(Writer delegate) {
            this.delegate = delegate;
        }

        @Override
        public void close() throws IOException {
            this.delegate.flush();
        }

        @Override
        public void flush() throws IOException {
            this.delegate.flush();
        }

        @Override
        public void write(int b) throws IOException {
            this.delegate.write(b);
        }

        @Override
        public void write(char[] buffer, int off, int len) throws IOException {
            this.delegate.write(buffer, off, len);
        }
    }
}

