/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.naturals.bitset;

import de.tum.in.naturals.bitset.BitSets;
import de.tum.in.naturals.bitset.PowerBitSetIterator;
import de.tum.in.naturals.bitset.PowerBitSetSimple;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.Size64;
import java.util.AbstractSet;
import java.util.BitSet;
import java.util.Iterator;
import javax.annotation.Nullable;

class PowerBitSet
extends AbstractSet<BitSet>
implements Size64 {
    private final BitSet baseSet;
    private final int baseSize;

    PowerBitSet(BitSet baseSet) {
        this.baseSet = (BitSet)baseSet.clone();
        this.baseSize = this.baseSet.cardinality();
    }

    @Override
    public boolean contains(@Nullable Object obj) {
        return obj instanceof BitSet && BitSets.isSubset((BitSet)obj, this.baseSet);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof PowerBitSet) {
            PowerBitSet other = (PowerBitSet)obj;
            return this.baseSet.equals(other.baseSet);
        }
        if (obj instanceof PowerBitSetSimple) {
            PowerBitSetSimple other = (PowerBitSetSimple)obj;
            return this.getBaseCardinality() == other.getBaseSize() && this.getBaseLength() == other.getBaseSize();
        }
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return HashCommon.mix((int)this.baseSet.hashCode());
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public Iterator<BitSet> iterator() {
        return new PowerBitSetIterator(this.baseSet);
    }

    @Override
    public int size() {
        return this.baseSize >= 32 ? Integer.MAX_VALUE : 1 << this.baseSize;
    }

    public long size64() {
        return 1L << this.baseSize;
    }

    @Override
    public String toString() {
        return String.format("powerSet(%s)", this.baseSet);
    }

    int getBaseCardinality() {
        return this.baseSize;
    }

    int getBaseLength() {
        return this.baseSet.length();
    }
}

