/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.naturals.set;

import de.tum.in.naturals.set.NatBitSet;
import it.unimi.dsi.fastutil.ints.IntBidirectionalIterator;
import java.util.NoSuchElementException;

class NatBitSetBidiIterator
implements IntBidirectionalIterator {
    private final NatBitSet set;
    private int previous;
    private int next;

    public NatBitSetBidiIterator(NatBitSet set) {
        this.set = set;
        this.previous = -1;
        this.next = set.nextPresentIndex(0);
    }

    public NatBitSetBidiIterator(NatBitSet set, int start) {
        this.set = set;
        if (start == 0) {
            this.previous = -1;
            this.next = set.nextPresentIndex(0);
        } else {
            this.previous = set.previousPresentIndex(start - 1);
            this.next = set.nextPresentIndex(start);
        }
    }

    public boolean hasNext() {
        return this.next != -1;
    }

    public boolean hasPrevious() {
        return this.previous != -1;
    }

    public int nextInt() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.previous = this.next;
        this.next = this.set.nextPresentIndex(this.next + 1);
        return this.previous;
    }

    public int previousInt() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        this.next = this.previous;
        this.previous = this.next == 0 ? -1 : this.set.previousPresentIndex(this.next - 1);
        return this.next;
    }

    public void remove() {
        if (this.previous == -1) {
            throw new IllegalStateException();
        }
        this.set.clear(this.previous);
        this.previous = this.set.previousPresentIndex(this.previous - 1);
    }
}

