/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.naturals.set;

import de.tum.in.naturals.set.AbstractNatBitSet;
import de.tum.in.naturals.set.NatBitSetsUtil;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.NoSuchElementException;

class MutableSingletonNatBitSet
extends AbstractNatBitSet {
    private static final int EMPTY = Integer.MIN_VALUE;
    private int element;

    MutableSingletonNatBitSet() {
        this.setEmpty();
    }

    MutableSingletonNatBitSet(int element) {
        this.element = element;
    }

    private static void throwOperationUnsupported() {
        throw new UnsupportedOperationException("Singleton can hold at most one value");
    }

    @Override
    public boolean add(int index) {
        NatBitSetsUtil.checkNonNegative(index);
        if (index == this.element) {
            return false;
        }
        if (!this.isEmpty()) {
            MutableSingletonNatBitSet.throwOperationUnsupported();
        }
        this.setValue(index);
        return true;
    }

    @Override
    public void clear(int i) {
        if (i == this.element) {
            this.setEmpty();
        }
    }

    @Override
    public void clear(int from, int to) {
        NatBitSetsUtil.checkRange(from, to);
        if (this.isEmpty()) {
            return;
        }
        if (from <= this.element && this.element < to) {
            this.setEmpty();
        }
    }

    public void clear() {
        this.setEmpty();
    }

    @Override
    public MutableSingletonNatBitSet clone() {
        return (MutableSingletonNatBitSet)super.clone();
    }

    public boolean contains(int index) {
        return !this.isEmpty() && index == this.element;
    }

    @Override
    public int firstInt() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.element;
    }

    @Override
    public void flip(int index) {
        NatBitSetsUtil.checkNonNegative(index);
        if (this.isEmpty()) {
            this.element = index;
        } else if (index == this.element) {
            this.element = Integer.MIN_VALUE;
        } else {
            MutableSingletonNatBitSet.throwOperationUnsupported();
        }
    }

    @Override
    public void flip(int from, int to) {
        NatBitSetsUtil.checkRange(from, to);
        if (from == to) {
            return;
        }
        if (from + 1 != to) {
            MutableSingletonNatBitSet.throwOperationUnsupported();
        }
        this.flip(from);
    }

    public boolean isEmpty() {
        return this.element == Integer.MIN_VALUE;
    }

    @Override
    public IntIterator iterator() {
        return new SingletonSetIterator(this);
    }

    @Override
    public int lastInt() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.element;
    }

    @Override
    public int nextAbsentIndex(int index) {
        NatBitSetsUtil.checkNonNegative(index);
        return !this.isEmpty() && index == this.element ? this.element + 1 : index;
    }

    @Override
    public int nextPresentIndex(int index) {
        NatBitSetsUtil.checkNonNegative(index);
        if (this.isEmpty()) {
            return -1;
        }
        return index <= this.element ? this.element : -1;
    }

    @Override
    public int previousAbsentIndex(int index) {
        return !this.isEmpty() && index == this.element ? this.element - 1 : index;
    }

    @Override
    public int previousPresentIndex(int index) {
        return !this.isEmpty() && index >= this.element ? this.element : -1;
    }

    @Override
    public boolean remove(int index) {
        NatBitSetsUtil.checkNonNegative(index);
        if (this.isEmpty()) {
            return false;
        }
        if (index != this.element) {
            return false;
        }
        this.setEmpty();
        return true;
    }

    @Override
    public void set(int index) {
        NatBitSetsUtil.checkNonNegative(index);
        if (this.isEmpty()) {
            this.element = index;
        } else if (index != this.element) {
            MutableSingletonNatBitSet.throwOperationUnsupported();
        }
    }

    @Override
    public void set(int index, boolean value) {
        NatBitSetsUtil.checkNonNegative(index);
        if (this.isEmpty()) {
            if (value) {
                this.setValue(index);
            }
        } else if (index == this.element != value) {
            MutableSingletonNatBitSet.throwOperationUnsupported();
        }
    }

    @Override
    public void set(int from, int to) {
        NatBitSetsUtil.checkRange(from, to);
        if (from == to) {
            return;
        }
        if (from + 1 != to) {
            MutableSingletonNatBitSet.throwOperationUnsupported();
        }
        if (this.isEmpty()) {
            this.setValue(from);
        } else if (from != this.element) {
            MutableSingletonNatBitSet.throwOperationUnsupported();
        }
    }

    private void setEmpty() {
        this.element = Integer.MIN_VALUE;
    }

    private void setValue(int value) {
        assert (value >= 0 && this.isEmpty());
        this.element = value;
    }

    public int size() {
        return this.isEmpty() ? 0 : 1;
    }

    public int[] toIntArray() {
        int[] nArray;
        if (this.isEmpty()) {
            nArray = new int[]{};
        } else {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = this.element;
        }
        return nArray;
    }

    private static class SingletonSetIterator
    implements IntIterator {
        private final MutableSingletonNatBitSet set;
        private int element;

        public SingletonSetIterator(MutableSingletonNatBitSet set) {
            this.set = set;
            this.element = set.element;
        }

        public boolean hasNext() {
            return this.element != Integer.MIN_VALUE;
        }

        public int nextInt() {
            if (this.element == Integer.MIN_VALUE) {
                throw new NoSuchElementException();
            }
            this.element = Integer.MIN_VALUE;
            return this.set.element;
        }

        public void remove() {
            if (this.element != Integer.MIN_VALUE || this.set.isEmpty()) {
                throw new IllegalStateException();
            }
            this.set.clear();
        }
    }
}

