/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton;

import java.util.BitSet;
import java.util.Collection;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import owl.automaton.AbstractImplicitAutomaton;
import owl.automaton.EdgeTreeAutomatonMixin;
import owl.automaton.acceptance.OmegaAcceptance;
import owl.automaton.edge.Edge;
import owl.collections.ValuationTree;
import owl.factories.ValuationSetFactory;

public class ImplicitNonDeterministicEdgeTreeAutomaton<S, A extends OmegaAcceptance>
extends AbstractImplicitAutomaton<S, A>
implements EdgeTreeAutomatonMixin<S, A> {
    @Nullable
    private final BiFunction<S, BitSet, Set<Edge<S>>> edgesFunction;
    private final Function<S, ValuationTree<Edge<S>>> edgeTreeFunction;

    public ImplicitNonDeterministicEdgeTreeAutomaton(ValuationSetFactory factory, Collection<S> initialStates, A acceptance, @Nullable BiFunction<S, BitSet, Set<Edge<S>>> edgesFunction, Function<S, ValuationTree<Edge<S>>> edgeTreeFunction) {
        super(factory, initialStates, acceptance);
        this.edgesFunction = edgesFunction;
        this.edgeTreeFunction = edgeTreeFunction;
    }

    @Override
    public Set<Edge<S>> edges(S state, BitSet valuation) {
        assert (this.cache() == null || this.cache().contains(state));
        if (this.edgesFunction != null) {
            return this.edgesFunction.apply(state, valuation);
        }
        return EdgeTreeAutomatonMixin.super.edges(state, valuation);
    }

    @Override
    public ValuationTree<Edge<S>> edgeTree(S state) {
        assert (this.cache() == null || this.cache().contains(state));
        return this.edgeTreeFunction.apply(state);
    }
}

