/*
 * Decompiled with CFR 0.152.
 */
package owl.factories;

import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import owl.collections.ValuationTree;
import owl.ltl.BooleanConstant;
import owl.ltl.EquivalenceClass;
import owl.ltl.Formula;

public interface EquivalenceClassFactory {
    public List<String> variables();

    public EquivalenceClass of(Formula var1);

    default public EquivalenceClass getFalse() {
        return this.of(BooleanConstant.FALSE);
    }

    default public EquivalenceClass getTrue() {
        return this.of(BooleanConstant.TRUE);
    }

    public BitSet atomicPropositions(EquivalenceClass var1, boolean var2);

    public Set<Formula.ModalOperator> modalOperators(EquivalenceClass var1);

    public boolean implies(EquivalenceClass var1, EquivalenceClass var2);

    default public EquivalenceClass conjunction(Collection<EquivalenceClass> classes) {
        return this.conjunction(classes.iterator());
    }

    public EquivalenceClass conjunction(Iterator<EquivalenceClass> var1);

    default public EquivalenceClass disjunction(Collection<EquivalenceClass> classes) {
        return this.disjunction(classes.iterator());
    }

    public EquivalenceClass disjunction(Iterator<EquivalenceClass> var1);

    public EquivalenceClass substitute(EquivalenceClass var1, Function<? super Formula.ModalOperator, ? extends Formula> var2);

    public EquivalenceClass temporalStep(EquivalenceClass var1, BitSet var2);

    public EquivalenceClass temporalStepUnfold(EquivalenceClass var1, BitSet var2);

    public EquivalenceClass unfold(EquivalenceClass var1);

    public EquivalenceClass unfoldTemporalStep(EquivalenceClass var1, BitSet var2);

    public String toString(EquivalenceClass var1);

    public <T> ValuationTree<T> temporalStepTree(EquivalenceClass var1, Function<EquivalenceClass, Set<T>> var2);

    public double trueness(EquivalenceClass var1);
}

