/*
 * Decompiled with CFR 0.152.
 */
package owl.factories.jbdd;

import de.tum.in.jbdd.Bdd;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.IntUnaryOperator;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import owl.collections.ValuationTree;
import owl.factories.EquivalenceClassFactory;
import owl.factories.jbdd.GcManagedFactory;
import owl.ltl.BooleanConstant;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.EquivalenceClass;
import owl.ltl.Formula;
import owl.ltl.Literal;
import owl.ltl.XOperator;
import owl.ltl.visitors.PrintVisitor;
import owl.ltl.visitors.PropositionalIntVisitor;

final class EquivalenceFactory
extends GcManagedFactory<BddEquivalenceClass>
implements EquivalenceClassFactory {
    private final List<String> alphabet;
    private final boolean keepRepresentatives;
    private final BddVisitor visitor;
    private final BddEquivalenceClass falseClass;
    private final BddEquivalenceClass trueClass;
    private Formula.TemporalOperator[] reverseMapping;
    private final Object2IntMap<Formula.TemporalOperator> mapping;
    private int[] temporalStepSubstitution;
    private int[] unfoldSubstitution;
    private EquivalenceClass[] temporalStepSubstitutes;
    private EquivalenceClass[] unfoldSubstitutes;
    private boolean registerActive = false;

    public EquivalenceFactory(Bdd factory, List<String> alphabet, boolean keepRepresentatives) {
        super(factory);
        this.alphabet = List.copyOf(alphabet);
        this.keepRepresentatives = keepRepresentatives;
        int alphabetSize = this.alphabet.size();
        this.mapping = new Object2IntOpenHashMap();
        this.mapping.defaultReturnValue(-1);
        this.reverseMapping = new Formula.TemporalOperator[alphabetSize];
        this.visitor = new BddVisitor();
        this.unfoldSubstitution = new int[alphabetSize];
        this.unfoldSubstitutes = new EquivalenceClass[alphabetSize];
        this.temporalStepSubstitution = new int[alphabetSize];
        this.temporalStepSubstitutes = new EquivalenceClass[alphabetSize];
        for (int i = 0; i < alphabetSize; ++i) {
            Literal literal = Literal.of(i);
            int bdd = factory.createVariable();
            assert (factory.getVariable(bdd) == i);
            this.mapping.put((Object)literal, i);
            this.reverseMapping[i] = literal;
        }
        Arrays.fill(this.unfoldSubstitution, -1);
        this.trueClass = new BddEquivalenceClass(this, factory.getTrueNode(), BooleanConstant.TRUE);
        this.falseClass = new BddEquivalenceClass(this, factory.getFalseNode(), BooleanConstant.FALSE);
    }

    @Override
    public List<String> variables() {
        return this.alphabet;
    }

    @Override
    public EquivalenceClass of(Formula formula) {
        return this.create(formula, this.toBdd(formula));
    }

    @Override
    public EquivalenceClass getFalse() {
        return this.falseClass;
    }

    @Override
    public EquivalenceClass getTrue() {
        return this.trueClass;
    }

    @Override
    public BitSet atomicPropositions(EquivalenceClass clazz, boolean includeNested) {
        if (!includeNested) {
            return this.factory.support(this.getBdd(clazz), this.alphabet.size());
        }
        BitSet atomicPropositions = this.factory.support(this.getBdd(clazz));
        int i = atomicPropositions.nextSetBit(this.alphabet.size());
        while (i >= 0) {
            atomicPropositions.or(this.reverseMapping[i].atomicPropositions(true));
            i = atomicPropositions.nextSetBit(i + 1);
        }
        if (atomicPropositions.length() >= this.alphabet.size()) {
            atomicPropositions.clear(this.alphabet.size(), atomicPropositions.length());
        }
        return atomicPropositions;
    }

    @Override
    public Set<Formula.ModalOperator> modalOperators(EquivalenceClass clazz) {
        final BitSet support = this.factory.support(this.getBdd(clazz));
        support.clear(0, this.alphabet.size());
        return new AbstractSet<Formula.ModalOperator>(){

            @Override
            public boolean contains(Object o) {
                int i = EquivalenceFactory.this.mapping.getInt(o);
                return i != -1 && support.get(i);
            }

            @Override
            public Stream<Formula.ModalOperator> stream() {
                return support.stream().mapToObj(i -> (Formula.ModalOperator)EquivalenceFactory.this.reverseMapping[i]);
            }

            @Override
            public Iterator<Formula.ModalOperator> iterator() {
                return this.stream().iterator();
            }

            @Override
            public int size() {
                return support.cardinality();
            }
        };
    }

    @Override
    public boolean implies(EquivalenceClass clazz, EquivalenceClass other) {
        return this.factory.implies(this.getBdd(clazz), this.getBdd(other));
    }

    @Override
    public EquivalenceClass conjunction(Iterator<EquivalenceClass> classes) {
        int resultBdd = this.factory.getTrueNode();
        ArrayList<Formula> representatives = new ArrayList<Formula>();
        while (classes.hasNext()) {
            EquivalenceClass next = classes.next();
            Formula representative = next.representative();
            if (representative == null || representatives == null) {
                representatives = null;
            } else {
                representatives.add(representative);
            }
            resultBdd = this.factory.and(resultBdd, this.getBdd(next));
        }
        return this.create(representatives == null ? null : Conjunction.of(representatives), resultBdd);
    }

    @Override
    public EquivalenceClass disjunction(Iterator<EquivalenceClass> classes) {
        int resultBdd = this.factory.getFalseNode();
        ArrayList<Formula> representatives = new ArrayList<Formula>();
        while (classes.hasNext()) {
            EquivalenceClass next = classes.next();
            Formula representative = next.representative();
            if (representative == null || representatives == null) {
                representatives = null;
            } else {
                representatives.add(representative);
            }
            resultBdd = this.factory.or(resultBdd, this.getBdd(next));
        }
        return this.create(representatives == null ? null : Disjunction.of(representatives), resultBdd);
    }

    @Override
    public EquivalenceClass substitute(EquivalenceClass clazz, Function<? super Formula.ModalOperator, ? extends Formula> substitution) {
        BitSet support = this.factory.support(this.getBdd(clazz));
        Function<Formula.TemporalOperator, Formula> guardedSubstitution = x -> {
            if (x instanceof Formula.ModalOperator) {
                return (Formula)substitution.apply((Formula.ModalOperator)x);
            }
            return x;
        };
        int[] substitutionMap = new int[this.reverseMapping.length];
        Arrays.setAll(substitutionMap, i -> support.get(i) ? this.toBdd((Formula)guardedSubstitution.apply(this.reverseMapping[i])) : -1);
        return this.transform(clazz, bdd -> this.factory.compose(bdd, substitutionMap), f -> f.substitute(guardedSubstitution));
    }

    @Override
    public EquivalenceClass temporalStep(EquivalenceClass clazz, BitSet valuation) {
        return this.transform(clazz, bdd -> this.temporalStepBdd(bdd, valuation), f -> f.temporalStep(valuation));
    }

    @Override
    public EquivalenceClass temporalStepUnfold(EquivalenceClass clazz, BitSet valuation) {
        return this.transform(clazz, bdd -> this.unfold(this.temporalStepBdd(bdd, valuation)), f -> f.temporalStepUnfold(valuation));
    }

    private int temporalStepBdd(int bdd, BitSet valuation) {
        for (int i = 0; i < this.alphabet.size(); ++i) {
            this.temporalStepSubstitution[i] = valuation.get(i) ? this.factory.getTrueNode() : this.factory.getFalseNode();
        }
        return this.factory.compose(bdd, this.temporalStepSubstitution);
    }

    @Override
    public EquivalenceClass unfold(EquivalenceClass clazz) {
        return this.transform(clazz, this::unfold, Formula::unfold);
    }

    @Override
    public EquivalenceClass unfoldTemporalStep(EquivalenceClass clazz, BitSet valuation) {
        return this.transform(clazz, bdd -> this.temporalStepBdd(this.unfold(bdd), valuation), f -> f.unfoldTemporalStep(valuation));
    }

    private int unfold(int bdd) {
        return this.factory.compose(bdd, this.unfoldSubstitution);
    }

    @Override
    public String toString(EquivalenceClass clazz) {
        int bdd = this.getBdd(clazz);
        if (this.factory.isVariable(bdd)) {
            return PrintVisitor.toString(this.reverseMapping[this.factory.getVariable(bdd)], this.alphabet, false);
        }
        if (this.factory.isVariableNegated(bdd)) {
            return PrintVisitor.toString(this.reverseMapping[this.factory.getVariable(bdd)].not(), this.alphabet, false);
        }
        Formula representative = clazz.representative();
        return representative == null ? String.format("%d", bdd) : PrintVisitor.toString(representative, this.alphabet, false);
    }

    @Override
    public <T> ValuationTree<T> temporalStepTree(EquivalenceClass clazz, Function<EquivalenceClass, Set<T>> mapper) {
        return this.temporalStepTree(clazz, mapper, new HashMap<EquivalenceClass, ValuationTree<T>>());
    }

    @Override
    public double trueness(EquivalenceClass clazz) {
        return this.factory.countSatisfyingAssignments(this.getBdd(clazz)) / StrictMath.pow(2.0, this.factory.numberOfVariables());
    }

    private <T> ValuationTree<T> temporalStepTree(EquivalenceClass clazz, Function<EquivalenceClass, Set<T>> mapper, Map<EquivalenceClass, ValuationTree<T>> cache) {
        int pivot;
        ValuationTree<T> tree = cache.get(clazz);
        if (tree != null) {
            return tree;
        }
        int bdd = this.getBdd(clazz);
        int n = pivot = this.factory.isNodeRoot(bdd) ? this.alphabet.size() : this.factory.getVariable(bdd);
        if (pivot >= this.alphabet.size()) {
            Arrays.fill(this.temporalStepSubstitution, 0, this.alphabet.size(), -1);
            Set<T> value = mapper.apply(this.transform(clazz, x -> this.factory.compose(x, this.temporalStepSubstitution), Formula::temporalStep));
            tree = ValuationTree.of(value);
        } else {
            int[] substitution = new int[pivot + 1];
            Arrays.fill(substitution, 0, pivot, -1);
            substitution[pivot] = this.factory.getTrueNode();
            ValuationTree<T> trueSubTree = this.temporalStepTree(this.transform(clazz, x -> this.factory.compose(this.getBdd(clazz), substitution), x -> x.temporalStep(pivot, true)), mapper, cache);
            substitution[pivot] = this.factory.getFalseNode();
            ValuationTree<T> falseSubTree = this.temporalStepTree(this.transform(clazz, x -> this.factory.compose(this.getBdd(clazz), substitution), x -> x.temporalStep(pivot, false)), mapper, cache);
            tree = ValuationTree.of(pivot, trueSubTree, falseSubTree);
        }
        cache.put(clazz, tree);
        return tree;
    }

    private BddEquivalenceClass getClass(EquivalenceClass clazz) {
        assert (this.equals(clazz.factory()));
        return (BddEquivalenceClass)clazz;
    }

    private int getBdd(EquivalenceClass clazz) {
        int bdd = this.getClass((EquivalenceClass)clazz).bdd;
        assert (this.factory.getReferenceCount(bdd) == 1 || this.factory.getReferenceCount(bdd) == -1);
        return bdd;
    }

    private int toBdd(Formula formula) {
        List newPropositions = formula.subformulas(Formula.ModalOperator.class).stream().filter(x -> !this.mapping.containsKey(x)).sorted().collect(Collectors.toList());
        if (!newPropositions.isEmpty()) {
            int variable;
            if (this.registerActive) {
                throw new ConcurrentModificationException("Detected recursive or parallel modification of BDD data-structures.");
            }
            this.registerActive = true;
            this.checkLiteralAlphabetRange(newPropositions);
            int newSize = this.mapping.size() + newPropositions.size();
            this.reverseMapping = Arrays.copyOf(this.reverseMapping, newSize);
            for (Formula.ModalOperator proposition : newPropositions) {
                variable = this.factory.getVariable(this.factory.createVariable());
                this.mapping.put((Object)proposition, variable);
                this.reverseMapping[variable] = proposition;
            }
            this.unfoldSubstitution = Arrays.copyOf(this.unfoldSubstitution, newSize);
            this.unfoldSubstitutes = Arrays.copyOf(this.unfoldSubstitutes, newSize);
            this.temporalStepSubstitution = Arrays.copyOf(this.temporalStepSubstitution, newSize);
            this.temporalStepSubstitutes = Arrays.copyOf(this.temporalStepSubstitutes, newSize);
            for (Formula.ModalOperator proposition : newPropositions) {
                BddEquivalenceClass clazz;
                variable = this.mapping.getInt((Object)proposition);
                if (proposition instanceof XOperator) {
                    Formula operand = ((XOperator)proposition).operand;
                    clazz = this.create(operand, this.toBdd(operand));
                    this.unfoldSubstitution[variable] = -1;
                    this.temporalStepSubstitutes[variable] = clazz;
                    this.temporalStepSubstitution[variable] = clazz.bdd;
                    continue;
                }
                Formula unfold = proposition.unfold();
                clazz = this.create(unfold, this.toBdd(unfold));
                this.unfoldSubstitutes[variable] = clazz;
                this.unfoldSubstitution[variable] = clazz.bdd;
                this.temporalStepSubstitution[variable] = -1;
            }
            if (!this.registerActive) {
                throw new ConcurrentModificationException("Detected recursive or parallel modification of BDD data-structures.");
            }
            this.registerActive = false;
        }
        return this.factory.dereference(formula.accept(this.visitor));
    }

    private BddEquivalenceClass create(@Nullable Formula representative, int bdd) {
        if (bdd == this.factory.getTrueNode()) {
            return this.trueClass;
        }
        if (bdd == this.factory.getFalseNode()) {
            return this.falseClass;
        }
        return this.canonicalize(new BddEquivalenceClass(this, bdd, this.keepRepresentatives ? representative : null));
    }

    private BddEquivalenceClass transform(EquivalenceClass clazz, IntUnaryOperator bddTransformer, UnaryOperator<Formula> representativeTransformer) {
        BddEquivalenceClass casted = this.getClass(clazz);
        int newBdd = bddTransformer.applyAsInt(casted.bdd);
        Formula representative = clazz.representative();
        Object newRepresentative = casted.bdd == newBdd ? representative : (representative == null ? null : (Formula)representativeTransformer.apply(representative));
        return this.create((Formula)newRepresentative, newBdd);
    }

    private void checkLiteralAlphabetRange(Collection<? extends Formula> formulas) {
        for (Formula formula : formulas) {
            if (!(formula instanceof Literal) || ((Literal)formula).getAtom() < this.alphabet.size()) continue;
            throw new IllegalArgumentException("Literal " + formula + " is not within alphabet.");
        }
    }

    private final class BddVisitor
    extends PropositionalIntVisitor {
        private BddVisitor() {
        }

        @Override
        protected int visit(Formula.TemporalOperator formula) {
            if (formula instanceof Literal) {
                Literal literal = (Literal)formula;
                EquivalenceFactory.this.checkLiteralAlphabetRange(List.of(literal));
                int variableBdd = EquivalenceFactory.this.factory.getVariableNode(literal.getAtom());
                return literal.isNegated() ? EquivalenceFactory.this.factory.not(variableBdd) : variableBdd;
            }
            int value = EquivalenceFactory.this.mapping.getInt((Object)formula);
            assert (formula instanceof Formula.ModalOperator);
            assert (value >= 0);
            return EquivalenceFactory.this.factory.getVariableNode(value);
        }

        @Override
        public int visit(BooleanConstant booleanConstant) {
            return booleanConstant.value ? EquivalenceFactory.this.factory.getTrueNode() : EquivalenceFactory.this.factory.getFalseNode();
        }

        @Override
        public int visit(Conjunction conjunction) {
            int x = EquivalenceFactory.this.factory.getTrueNode();
            for (Formula child : conjunction.children) {
                int y = child.accept(this);
                x = EquivalenceFactory.this.factory.consume(EquivalenceFactory.this.factory.and(x, y), x, y);
            }
            return x;
        }

        @Override
        public int visit(Disjunction disjunction) {
            int x = EquivalenceFactory.this.factory.getFalseNode();
            for (Formula child : disjunction.children) {
                int y = child.accept(this);
                x = EquivalenceFactory.this.factory.consume(EquivalenceFactory.this.factory.or(x, y), x, y);
            }
            return x;
        }
    }

    public static final class BddEquivalenceClass
    extends EquivalenceClass
    implements GcManagedFactory.BddWrapper {
        final int bdd;

        BddEquivalenceClass(EquivalenceClassFactory factory, int bdd, @Nullable Formula representative) {
            super(factory, representative);
            this.bdd = bdd;
        }

        @Override
        public int bdd() {
            return this.bdd;
        }

        public int hashCode() {
            return HashCommon.mix((int)this.bdd);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            BddEquivalenceClass that = (BddEquivalenceClass)obj;
            assert (this.factory().equals(that.factory()));
            return this.bdd == that.bdd;
        }
    }
}

