/*
 * Decompiled with CFR 0.152.
 */
package owl.ltl.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import owl.grammar.LTLParser;
import owl.grammar.LTLParserBaseVisitor;
import owl.ltl.Biconditional;
import owl.ltl.BooleanConstant;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.FOperator;
import owl.ltl.Formula;
import owl.ltl.FrequencyG;
import owl.ltl.GOperator;
import owl.ltl.Literal;
import owl.ltl.MOperator;
import owl.ltl.ROperator;
import owl.ltl.UOperator;
import owl.ltl.WOperator;
import owl.ltl.XOperator;

final class LtlParseTreeVisitor
extends LTLParserBaseVisitor<Formula> {
    private final List<Literal> literalCache;
    private final List<String> variables;
    private final boolean fixedVariables;

    LtlParseTreeVisitor() {
        this.literalCache = new ArrayList<Literal>();
        this.variables = new ArrayList<String>();
        this.fixedVariables = false;
    }

    LtlParseTreeVisitor(List<String> literals) {
        ListIterator<String> literalIterator = literals.listIterator();
        ArrayList<Literal> literalList = new ArrayList<Literal>();
        ArrayList<String> variableList = new ArrayList<String>();
        while (literalIterator.hasNext()) {
            int index = literalIterator.nextIndex();
            String name = literalIterator.next();
            literalList.add(Literal.of(index));
            variableList.add(name);
        }
        this.literalCache = List.copyOf(literalList);
        this.variables = List.copyOf(variableList);
        this.fixedVariables = true;
    }

    public List<String> variables() {
        return List.copyOf(this.variables);
    }

    @Override
    public Formula visitAndExpression(LTLParser.AndExpressionContext ctx) {
        assert (ctx.getChildCount() > 0);
        return Conjunction.of(ctx.children.stream().filter(child -> !(child instanceof TerminalNode)).map(arg_0 -> ((LtlParseTreeVisitor)this).visit(arg_0)));
    }

    @Override
    public Formula visitBinaryOperation(LTLParser.BinaryOperationContext ctx) {
        assert (ctx.getChildCount() == 3);
        assert (ctx.left != null && ctx.right != null);
        LTLParser.BinaryOpContext binaryOp = ctx.binaryOp();
        Formula left = (Formula)this.visit((ParseTree)ctx.left);
        Formula right = (Formula)this.visit((ParseTree)ctx.right);
        if (binaryOp.BIIMP() != null) {
            return Biconditional.of(left, right);
        }
        if (binaryOp.IMP() != null) {
            return Disjunction.of(left.not(), right);
        }
        if (binaryOp.XOR() != null) {
            return Biconditional.of(left.not(), right);
        }
        if (binaryOp.UNTIL() != null) {
            return UOperator.of(left, right);
        }
        if (binaryOp.WUNTIL() != null) {
            return WOperator.of(left, right);
        }
        if (binaryOp.RELEASE() != null) {
            return ROperator.of(left, right);
        }
        if (binaryOp.SRELEASE() != null) {
            return MOperator.of(left, right);
        }
        throw new ParseCancellationException("Unknown operator");
    }

    @Override
    public Formula visitBoolean(LTLParser.BooleanContext ctx) {
        assert (ctx.getChildCount() == 1);
        LTLParser.BoolContext constant = ctx.bool();
        if (constant.FALSE() != null) {
            return BooleanConstant.FALSE;
        }
        if (constant.TRUE() != null) {
            return BooleanConstant.TRUE;
        }
        throw new ParseCancellationException("Unknown constant");
    }

    @Override
    public Formula visitExpression(LTLParser.ExpressionContext ctx) {
        assert (ctx.getChildCount() == 1);
        return (Formula)this.visit(ctx.getChild(0));
    }

    @Override
    public Formula visitFormula(LTLParser.FormulaContext ctx) {
        assert (ctx.getChildCount() == 2) : ctx.getChildCount();
        return (Formula)this.visit(ctx.getChild(0));
    }

    @Override
    public Formula visitNested(LTLParser.NestedContext ctx) {
        assert (ctx.getChildCount() == 3);
        return (Formula)this.visit((ParseTree)ctx.nested);
    }

    @Override
    public Formula visitOrExpression(LTLParser.OrExpressionContext ctx) {
        assert (ctx.getChildCount() > 0);
        return Disjunction.of(ctx.children.stream().filter(child -> !(child instanceof TerminalNode)).map(arg_0 -> ((LtlParseTreeVisitor)this).visit(arg_0)));
    }

    @Override
    public Formula visitUnaryOperation(LTLParser.UnaryOperationContext ctx) {
        assert (ctx.getChildCount() == 2);
        LTLParser.UnaryOpContext unaryOp = ctx.unaryOp();
        Formula operand = (Formula)this.visit((ParseTree)ctx.inner);
        if (unaryOp.NOT() != null) {
            return operand.not();
        }
        if (unaryOp.FINALLY() != null) {
            return FOperator.of(operand);
        }
        if (unaryOp.GLOBALLY() != null) {
            return GOperator.of(operand);
        }
        if (unaryOp.NEXT() != null) {
            return XOperator.of(operand);
        }
        if (unaryOp.frequencyOp() != null) {
            double finalValue;
            Formula finalFormula;
            double value;
            boolean negateOperator;
            boolean negateComparison;
            FrequencyG.Comparison comparison;
            LTLParser.FrequencyOpContext freqCtx = unaryOp.frequencyOp();
            assert (freqCtx.op != null && freqCtx.comp != null && freqCtx.prob != null);
            if (freqCtx.comp.GE() != null) {
                comparison = FrequencyG.Comparison.GEQ;
                negateComparison = false;
            } else if (freqCtx.comp.GT() != null) {
                comparison = FrequencyG.Comparison.GT;
                negateComparison = false;
            } else if (freqCtx.comp.LE() != null) {
                comparison = FrequencyG.Comparison.GT;
                negateComparison = true;
            } else if (freqCtx.comp.LT() != null) {
                comparison = FrequencyG.Comparison.GEQ;
                negateComparison = true;
            } else {
                throw new ParseCancellationException("Unknown comparison");
            }
            if (freqCtx.GLOBALLY() != null) {
                negateOperator = false;
            } else if (freqCtx.FINALLY() != null) {
                negateOperator = true;
            } else {
                throw new ParseCancellationException("Unknown operator");
            }
            if (freqCtx.prob instanceof LTLParser.FractionContext) {
                double denominator;
                double numerator;
                LTLParser.FractionContext fraction = (LTLParser.FractionContext)freqCtx.prob;
                String numeratorString = fraction.numerator.getText();
                String denominatorString = fraction.denominator.getText();
                try {
                    numerator = Double.parseDouble(numeratorString);
                    denominator = Double.parseDouble(denominatorString);
                }
                catch (NumberFormatException e) {
                    throw new ParseCancellationException("Invalid numbers", (Throwable)e);
                }
                value = numerator / denominator;
                if (value < 0.0 || 1.0 < value) {
                    throw new ParseCancellationException("Invalid numbers");
                }
            } else if (freqCtx.prob instanceof LTLParser.ProbabilityContext) {
                LTLParser.ProbabilityContext probability = (LTLParser.ProbabilityContext)freqCtx.prob;
                String valueString = probability.value.getText();
                value = Double.parseDouble(valueString);
            } else {
                throw new ParseCancellationException("Unknown frequency spec");
            }
            FrequencyG.Limes limes = freqCtx.SUP() != null ? FrequencyG.Limes.SUP : FrequencyG.Limes.INF;
            if (negateComparison == negateOperator) {
                finalFormula = operand;
                finalValue = value;
            } else {
                finalFormula = operand.not();
                finalValue = 1.0 - value;
            }
            return new FrequencyG(finalFormula, finalValue, comparison, limes);
        }
        throw new AssertionError((Object)"Unreachable Code");
    }

    @Override
    public Formula visitVariable(LTLParser.VariableContext ctx) {
        assert (ctx.getChildCount() == 1);
        return this.createVariable(ctx.getText());
    }

    @Override
    public Formula visitSingleQuotedVariable(LTLParser.SingleQuotedVariableContext ctx) {
        assert (ctx.getChildCount() == 3);
        return this.createVariable(ctx.variable.getText());
    }

    @Override
    public Formula visitDoubleQuotedVariable(LTLParser.DoubleQuotedVariableContext ctx) {
        assert (ctx.getChildCount() == 3);
        return this.createVariable(ctx.variable.getText());
    }

    private Formula createVariable(String name) {
        assert (this.variables.size() == this.literalCache.size());
        int index = this.variables.indexOf(name);
        if (index == -1) {
            if (this.fixedVariables) {
                throw new IllegalStateException("Encountered unknown variable " + name + " with fixed set " + this.variables);
            }
            int newIndex = this.variables.size();
            Literal literal = Literal.of(newIndex);
            this.variables.add(name);
            this.literalCache.add(literal);
            return literal;
        }
        return this.literalCache.get(index);
    }
}

