/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.canonical;

import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.immutables.value.Value;
import owl.collections.ValuationTree;
import owl.ltl.BooleanConstant;
import owl.ltl.Formula;
import owl.ltl.UnaryModalOperator;
import owl.translations.canonical.PairTuple;
import owl.util.annotation.Tuple;

class Util {
    private Util() {
    }

    static ValuationTree<BitSet> singleStepTree(List<Formula> singleSteps) {
        return Util.singleStepTreeRecursive(singleSteps, new HashMap<List<Formula>, ValuationTree<BitSet>>());
    }

    private static ValuationTree<BitSet> singleStepTreeRecursive(List<Formula> singleSteps, Map<List<Formula>, ValuationTree<BitSet>> cache) {
        ValuationTree<BitSet> result = cache.get(singleSteps);
        if (result != null) {
            return result;
        }
        int nextVariable = -1;
        for (Formula x : singleSteps) {
            int i2 = x.atomicPropositions(false).nextSetBit(0);
            if (0 > i2 || nextVariable >= 0 && i2 >= nextVariable) continue;
            nextVariable = i2;
        }
        if (nextVariable == -1) {
            BitSet acceptance = new BitSet();
            for (int i3 = 0; i3 < singleSteps.size(); ++i3) {
                if (!((BooleanConstant)singleSteps.get((int)i3)).value) continue;
                acceptance.set(i3 + 1);
            }
            result = ValuationTree.of(Set.of(acceptance));
        } else {
            int variable = nextVariable;
            Formula[] trueSingleSteps = new Formula[singleSteps.size()];
            Formula[] falseSingleSteps = new Formula[singleSteps.size()];
            Arrays.setAll(trueSingleSteps, i -> ((Formula)singleSteps.get(i)).temporalStep(variable, true));
            Arrays.setAll(falseSingleSteps, i -> ((Formula)singleSteps.get(i)).temporalStep(variable, false));
            ValuationTree<BitSet> trueChild = Util.singleStepTreeRecursive(Arrays.asList(trueSingleSteps), cache);
            ValuationTree<BitSet> falseChild = Util.singleStepTreeRecursive(Arrays.asList(falseSingleSteps), cache);
            result = ValuationTree.of(variable, trueChild, falseChild);
        }
        cache.put(singleSteps, result);
        return result;
    }

    static Formula unwrap(Formula formula) {
        return ((UnaryModalOperator)formula).operand;
    }

    @Value.Immutable
    @Tuple
    static abstract class Pair<A, B> {
        Pair() {
        }

        public abstract A a();

        public abstract B b();

        public static <A, B> Pair<A, B> of(A a, B b) {
            return PairTuple.create(a, b);
        }
    }
}

