/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.ltl2ldba;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import owl.automaton.Automaton;
import owl.automaton.ImplicitNonDeterministicEdgeTreeAutomaton;
import owl.automaton.MutableAutomaton;
import owl.automaton.MutableAutomatonFactory;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.acceptance.GeneralizedBuchiAcceptance;
import owl.automaton.acceptance.NoneAcceptance;
import owl.automaton.edge.Edge;
import owl.collections.Collections3;
import owl.collections.ValuationTree;
import owl.collections.ValuationTrees;
import owl.factories.Factories;
import owl.ltl.BooleanConstant;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.EquivalenceClass;
import owl.ltl.Formula;
import owl.ltl.LabelledFormula;
import owl.ltl.SyntacticFragment;
import owl.ltl.SyntacticFragments;
import owl.ltl.XOperator;
import owl.ltl.rewriter.NormalForms;
import owl.run.Environment;
import owl.translations.canonical.DeterministicConstructions;
import owl.translations.canonical.RoundRobinState;
import owl.translations.ltl2ldba.AnnotatedLDBA;
import owl.translations.ltl2ldba.BlockingModalOperatorsVisitor;
import owl.translations.ltl2ldba.SymmetricProductState;
import owl.translations.mastertheorem.Fixpoints;
import owl.translations.mastertheorem.Predicates;
import owl.translations.mastertheorem.Rewriter;
import owl.translations.mastertheorem.Selector;
import owl.translations.mastertheorem.SymmetricEvaluatedFixpoints;

public final class SymmetricLDBAConstruction<B extends GeneralizedBuchiAcceptance>
implements Function<LabelledFormula, AnnotatedLDBA<Map<Integer, EquivalenceClass>, SymmetricProductState, B, SortedSet<SymmetricEvaluatedFixpoints>, BiFunction<Integer, EquivalenceClass, Set<SymmetricProductState>>>> {
    private final Class<? extends B> acceptanceClass;
    private final Environment environment;

    private SymmetricLDBAConstruction(Environment environment, Class<? extends B> acceptanceClass) {
        this.environment = environment;
        this.acceptanceClass = acceptanceClass;
        assert (BuchiAcceptance.class.equals(acceptanceClass) || GeneralizedBuchiAcceptance.class.equals(acceptanceClass));
    }

    public static <B extends GeneralizedBuchiAcceptance> SymmetricLDBAConstruction<B> of(Environment environment, Class<? extends B> clazz) {
        return new SymmetricLDBAConstruction<B>(environment, clazz);
    }

    @Override
    public AnnotatedLDBA<Map<Integer, EquivalenceClass>, SymmetricProductState, B, SortedSet<SymmetricEvaluatedFixpoints>, BiFunction<Integer, EquivalenceClass, Set<SymmetricProductState>>> apply(LabelledFormula input) {
        LabelledFormula formula = SyntacticFragments.normalize(input, SyntacticFragment.NNF);
        Factories factories = this.environment.factorySupplier().getFactories(formula.variables(), true);
        ArrayList<BlockingElements> blockingElements = new ArrayList<BlockingElements>(List.of(new BlockingElements(BooleanConstant.TRUE)));
        HashMap epsilonJumps = new HashMap();
        int acceptanceSets = 1;
        HashSet<Fixpoints> knownFixpoints = new HashSet<Fixpoints>();
        HashMap<Fixpoints, Set<SymmetricEvaluatedFixpoints>> evaluationMap = new HashMap<Fixpoints, Set<SymmetricEvaluatedFixpoints>>();
        HashMap<SymmetricEvaluatedFixpoints, SymmetricEvaluatedFixpoints.DeterministicAutomata> automataMap = new HashMap<SymmetricEvaluatedFixpoints, SymmetricEvaluatedFixpoints.DeterministicAutomata>();
        DeterministicConstructions.Tracking factory = new DeterministicConstructions.Tracking(factories, true);
        ArrayList initialFormulas = new ArrayList();
        Set<Formula> dnf = Collections3.transformSet(NormalForms.toDnf(formula.formula(), NormalForms.SYNTHETIC_CO_SAFETY_LITERAL), Conjunction::of);
        List<Set<Formula>> groupedDnf = Collections3.partition(dnf, SymmetricLDBAConstruction::groupInDnf);
        groupedDnf.forEach(x -> initialFormulas.add(Disjunction.of(x)));
        initialFormulas.sort(Formula::compareTo);
        for (Formula initialFormula : initialFormulas) {
            knownFixpoints.addAll(Selector.selectSymmetric(initialFormula, false));
            blockingElements.add(new BlockingElements(initialFormula));
        }
        for (Fixpoints fixpoints : knownFixpoints) {
            Fixpoints simplified = fixpoints.simplified();
            if (evaluationMap.containsKey(simplified)) continue;
            Set<SymmetricEvaluatedFixpoints> evaluatedSet = SymmetricEvaluatedFixpoints.build(simplified, factories);
            evaluationMap.put(simplified, evaluatedSet);
            for (SymmetricEvaluatedFixpoints evaluated : evaluatedSet) {
                if (automataMap.containsKey(evaluated)) continue;
                SymmetricEvaluatedFixpoints.DeterministicAutomata deterministicAutomata = evaluated.deterministicAutomata(factories, true, this.acceptanceClass.equals(GeneralizedBuchiAcceptance.class));
                automataMap.put(evaluated, deterministicAutomata);
                if (deterministicAutomata.gfCoSafetyAutomaton == null) continue;
                acceptanceSets = Math.max(acceptanceSets, deterministicAutomata.gfCoSafetyAutomaton.acceptance().acceptanceSets());
            }
        }
        Map<Integer, EquivalenceClass> initialState = new HashMap<Integer, EquivalenceClass>();
        for (int i = 0; i < initialFormulas.size(); ++i) {
            initialState.put(i + 1, factory.asInitialState((Formula)initialFormulas.get(i)));
        }
        initialState = SymmetricLDBAConstruction.canonicalState(initialState);
        AcceptingComponentBuilder acceptingComponentBuilder = new AcceptingComponentBuilder(this, factories, (GeneralizedBuchiAcceptance)this.acceptanceClass.cast(GeneralizedBuchiAcceptance.of(acceptanceSets)));
        BitSet accSets = new BitSet();
        accSets.set(0, acceptanceSets);
        Function<Map, ValuationTree> edgeTree = state -> {
            Map<Integer, ValuationTree> successors = state.entrySet().stream().map(x -> Map.entry((Integer)x.getKey(), factory.successorTree((EquivalenceClass)x.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            return ValuationTrees.cartesianProduct(successors).map(x -> {
                Map<Integer, EquivalenceClass> successor = SymmetricLDBAConstruction.canonicalState((Map)Iterables.getOnlyElement((Iterable)x, null));
                if (successor == null) {
                    return Set.of();
                }
                return Set.of(SymmetricLDBAConstruction.isAccepting(successor) ? Edge.of(successor, accSets) : Edge.of(successor));
            });
        };
        ImplicitNonDeterministicEdgeTreeAutomaton<Map, NoneAcceptance> automaton = new ImplicitNonDeterministicEdgeTreeAutomaton<Map, NoneAcceptance>(factories.vsFactory, Collections3.ofNullable(initialState), NoneAcceptance.INSTANCE, null, edgeTree);
        Consumer<Map.Entry> jumpGenerator = entry -> {
            if (epsilonJumps.containsKey(entry)) {
                return;
            }
            EquivalenceClass clazz = (EquivalenceClass)entry.getValue();
            Set<Formula.ModalOperator> modalOperators = clazz.modalOperators();
            assert ((Integer)entry.getKey() != 0 || SyntacticFragments.isCoSafety(modalOperators) || SyntacticFragments.isSafety(modalOperators));
            if (((BlockingElements)blockingElements.get((Integer)entry.getKey())).isBlocked(clazz)) {
                epsilonJumps.put(entry, Set.of());
                return;
            }
            Set allModalOperators = modalOperators.stream().flatMap(x -> x.subformulas(Formula.ModalOperator.class).stream()).collect(Collectors.toUnmodifiableSet());
            Set availableFixpoints = knownFixpoints.stream().filter(x -> x.allFixpointsPresent(allModalOperators)).map(Fixpoints::simplified).collect(Collectors.toSet());
            ArrayList<SymmetricProductState> jumps = new ArrayList<SymmetricProductState>();
            evaluationMap.forEach((fixpoints, set) -> {
                if (!availableFixpoints.contains(fixpoints)) {
                    return;
                }
                for (SymmetricEvaluatedFixpoints symmetricEvaluatedFixpoints : set) {
                    Set protectedXOperators;
                    EquivalenceClass remainder;
                    EquivalenceClass xRemovedRemainder = remainder = clazz.substitute(new Rewriter.ToSafety((Fixpoints)fixpoints)).unfold();
                    while (!(remainder = xRemovedRemainder).equals(xRemovedRemainder = remainder.substitute(arg_0 -> SymmetricLDBAConstruction.lambda$apply$7(protectedXOperators = remainder.modalOperators().stream().flatMap(x -> {
                        if (x instanceof XOperator) {
                            return Stream.empty();
                        }
                        return x.subformulas(XOperator.class).stream();
                    }).collect(Collectors.toSet()), arg_0)))) {
                    }
                    if (remainder.isFalse()) continue;
                    SymmetricEvaluatedFixpoints.DeterministicAutomata deterministicAutomata = (SymmetricEvaluatedFixpoints.DeterministicAutomata)automataMap.get(symmetricEvaluatedFixpoints);
                    EquivalenceClass safety = deterministicAutomata.safetyAutomaton.onlyInitialStateWithRemainder(remainder);
                    if (safety.isFalse()) continue;
                    jumps.add(new SymmetricProductState(safety, (RoundRobinState<EquivalenceClass>)(deterministicAutomata.gfCoSafetyAutomaton == null ? null : deterministicAutomata.gfCoSafetyAutomaton.onlyInitialState()), symmetricEvaluatedFixpoints, deterministicAutomata));
                }
            });
            jumps.sort(Comparator.comparing(x -> x.evaluatedFixpoints).reversed());
            epsilonJumps.put(entry, Set.copyOf(Collections3.maximalElements(jumps, (x, y) -> x.language().implies(y.language()))));
        };
        MutableAutomaton<Map, NoneAcceptance> initialComponent = MutableAutomatonFactory.copy(automaton);
        assert (initialComponent.is(Automaton.Property.DETERMINISTIC));
        initialComponent.states().forEach(x -> x.entrySet().forEach(jumpGenerator));
        initialComponent.name("LTL to LDBA (symmetric) for formula: " + formula);
        return AnnotatedLDBA.build(initialComponent, acceptingComponentBuilder, state -> {
            if (SymmetricLDBAConstruction.isAccepting(state) || SymmetricLDBAConstruction.containsUnresolvedFinite(state)) {
                return Set.of();
            }
            HashSet jumps = new HashSet();
            state.entrySet().forEach(x -> jumps.addAll((Collection)epsilonJumps.get(x)));
            return jumps;
        }, x -> (EquivalenceClass)x.values().stream().reduce(EquivalenceClass::or).orElseThrow(), (SortedSet)evaluationMap.values().stream().flatMap(Collection::stream).collect(Collectors.toCollection(TreeSet::new)), (x, y) -> (Set)epsilonJumps.get(Map.entry(x, y)));
    }

    private static boolean containsUnresolvedFinite(Map<?, EquivalenceClass> state) {
        return state.values().stream().anyMatch(SymmetricLDBAConstruction::containsUnresolvedFinite);
    }

    private static boolean containsUnresolvedFinite(EquivalenceClass clazz) {
        Set<Formula.ModalOperator> modalOperators = clazz.modalOperators();
        if (modalOperators.isEmpty()) {
            return true;
        }
        Set scopedXOperators = modalOperators.stream().flatMap(x -> x.children().stream().flatMap(y -> y.subformulas(XOperator.class).stream())).collect(Collectors.toSet());
        return modalOperators.stream().anyMatch(x -> x instanceof XOperator && !scopedXOperators.contains(x));
    }

    private static boolean groupInDnf(Formula x, Formula y) {
        Set<Formula.TemporalOperator> ySubformulas;
        if (SyntacticFragment.CO_SAFETY.contains(x) && SyntacticFragment.CO_SAFETY.contains(y)) {
            return true;
        }
        Set<Formula.TemporalOperator> xSubformulas = x.subformulas(Predicates.IS_GREATEST_FIXPOINT);
        return !Collections.disjoint(xSubformulas, ySubformulas = y.subformulas(Predicates.IS_GREATEST_FIXPOINT));
    }

    @Nullable
    private static Map<Integer, EquivalenceClass> canonicalState(@Nullable Map<Integer, EquivalenceClass> state) {
        if (state == null) {
            return null;
        }
        HashMap<Integer, EquivalenceClass> canonicalState = new HashMap<Integer, EquivalenceClass>();
        HashSet coSafety = new HashSet();
        state.forEach((index, clazz) -> {
            if (SyntacticFragments.isCoSafety(clazz.modalOperators())) {
                coSafety.add(clazz);
            } else if (!canonicalState.values().contains(clazz)) {
                canonicalState.put((Integer)index, (EquivalenceClass)clazz);
            }
        });
        assert (!canonicalState.containsKey(0) || SyntacticFragments.isSafety(((EquivalenceClass)canonicalState.get(0)).modalOperators()) || SyntacticFragments.isCoSafety(((EquivalenceClass)canonicalState.get(0)).modalOperators()));
        EquivalenceClass coSafetyClass = coSafety.stream().reduce(EquivalenceClass::or).orElse(null);
        if (coSafetyClass != null) {
            if (coSafetyClass.isTrue()) {
                return Map.of(0, coSafetyClass);
            }
            if (!coSafetyClass.isFalse()) {
                canonicalState.put(0, coSafetyClass);
            }
        }
        if (canonicalState.isEmpty()) {
            return null;
        }
        if (canonicalState.values().stream().allMatch(x -> SyntacticFragments.isSafety(x.modalOperators()))) {
            EquivalenceClass clazz2 = (EquivalenceClass)canonicalState.values().stream().reduce(EquivalenceClass::or).orElseThrow();
            if (clazz2.isFalse()) {
                return null;
            }
            return Map.of(0, clazz2);
        }
        return Map.copyOf(canonicalState);
    }

    private static boolean isAccepting(Map<Integer, EquivalenceClass> state) {
        return state.values().stream().allMatch(x -> SyntacticFragments.isSafety(x.modalOperators()));
    }

    private static /* synthetic */ Formula lambda$apply$7(Set protectedXOperators, Formula.ModalOperator x) {
        return x instanceof XOperator && !protectedXOperators.contains(x) ? BooleanConstant.FALSE : x;
    }

    private static class BlockingElements {
        private final BitSet atomicPropositions;
        private final Set<Formula.ModalOperator> modalOperators;

        private BlockingElements(Formula formula) {
            this.atomicPropositions = formula.atomicPropositions(true);
            formula.subformulas(Predicates.IS_FIXPOINT).forEach(x -> this.atomicPropositions.andNot(x.atomicPropositions(true)));
            this.modalOperators = Set.of((Formula.ModalOperator[])((Set)BlockingModalOperatorsVisitor.INSTANCE.apply(formula)).toArray(Formula.ModalOperator[]::new));
            assert (SyntacticFragments.isCoSafety(this.modalOperators));
        }

        private boolean isBlocked(EquivalenceClass clazz) {
            Set<Formula.ModalOperator> clazzModalOperators = clazz.modalOperators();
            if (SyntacticFragments.isCoSafety(clazzModalOperators)) {
                return true;
            }
            if (clazz.atomicPropositions(true).intersects(this.atomicPropositions)) {
                return true;
            }
            if (this.modalOperators.isEmpty()) {
                return false;
            }
            return !Collections.disjoint(this.modalOperators, clazzModalOperators);
        }
    }

    private static class AcceptingComponentBuilder
    implements AnnotatedLDBA.AcceptingComponentBuilder<SymmetricProductState, B> {
        private final List<SymmetricProductState> anchors = new ArrayList<SymmetricProductState>();
        private final Factories factories;
        private final B acceptance;
        final /* synthetic */ SymmetricLDBAConstruction this$0;

        private AcceptingComponentBuilder(Factories factories, B acceptance) {
            this.this$0 = var1_1;
            this.factories = factories;
            this.acceptance = acceptance;
        }

        @Override
        public void addInitialStates(Collection<? extends SymmetricProductState> initialStates) {
            this.anchors.addAll(List.copyOf(initialStates));
        }

        protected ValuationTree<Edge<SymmetricProductState>> edgeTree(SymmetricProductState state) {
            SymmetricEvaluatedFixpoints.DeterministicAutomata automata = Objects.requireNonNull(state.automata);
            EquivalenceClass safetyState = Objects.requireNonNull(state.safety);
            DeterministicConstructions.Safety safetyAutomaton = automata.safetyAutomaton;
            ValuationTree<Edge<EquivalenceClass>> safetyEdgeTree = safetyAutomaton.edgeTree(safetyState);
            if (automata.gfCoSafetyAutomaton == null) {
                Function<Edge, Edge> mapper = safetyEdge -> {
                    SymmetricProductState successor = new SymmetricProductState((EquivalenceClass)safetyEdge.successor(), null, state.evaluatedFixpoints, automata);
                    BitSet acceptance = new BitSet();
                    acceptance.set(0, ((GeneralizedBuchiAcceptance)this.acceptance).acceptanceSets());
                    return Edge.of(successor, acceptance);
                };
                return safetyEdgeTree.map(x -> x.stream().map(mapper).collect(Collectors.toUnmodifiableSet()));
            }
            RoundRobinState<EquivalenceClass> livenessState = Objects.requireNonNull(state.liveness);
            DeterministicConstructions.GfCoSafety livenessAutomaton = automata.gfCoSafetyAutomaton;
            ValuationTree<Edge<RoundRobinState<EquivalenceClass>>> livenessEdgeTree = livenessAutomaton.edgeTree(livenessState);
            assert (safetyEdgeTree.values().stream().allMatch(x -> x.largestAcceptanceSet() == -1));
            assert (livenessEdgeTree.values().stream().allMatch(x -> x.largestAcceptanceSet() < ((GeneralizedBuchiAcceptance)this.acceptance).acceptanceSets()));
            return ValuationTrees.cartesianProduct(safetyEdgeTree, livenessEdgeTree, (safetyEdge, livenessEdge) -> {
                SymmetricProductState successor = new SymmetricProductState((EquivalenceClass)safetyEdge.successor(), (RoundRobinState)livenessEdge.successor(), state.evaluatedFixpoints, automata);
                BitSet acceptance = new BitSet();
                livenessEdge.acceptanceSetIterator().forEachRemaining(acceptance::set);
                acceptance.set(livenessAutomaton.acceptance().acceptanceSets(), ((GeneralizedBuchiAcceptance)this.acceptance).acceptanceSets());
                return Edge.of(successor, acceptance);
            });
        }

        @Override
        public MutableAutomaton<SymmetricProductState, B> build() {
            return MutableAutomatonFactory.copy(new ImplicitNonDeterministicEdgeTreeAutomaton(this.factories.vsFactory, this.anchors, this.acceptance, null, this::edgeTree));
        }
    }
}

