/*
 * Decompiled with CFR 0.152.
 */
package owl.ltl.robust;

import java.util.EnumSet;
import java.util.List;
import java.util.function.UnaryOperator;
import org.immutables.value.Value;
import owl.ltl.Formula;
import owl.ltl.LabelledFormula;
import owl.ltl.robust.LabelledSplitTuple;
import owl.ltl.robust.Robustness;
import owl.ltl.robust.Split;
import owl.util.annotation.Tuple;

@Tuple
@Value.Immutable
public abstract class LabelledSplit {
    abstract Split split();

    public abstract List<String> variables();

    @Value.Derived
    public LabelledFormula always() {
        return LabelledFormula.of(this.split().always(), this.variables());
    }

    @Value.Derived
    public LabelledFormula eventuallyAlways() {
        return LabelledFormula.of(this.split().eventuallyAlways(), this.variables());
    }

    @Value.Derived
    public LabelledFormula infinitelyOften() {
        return LabelledFormula.of(this.split().infinitelyOften(), this.variables());
    }

    @Value.Derived
    public LabelledFormula eventually() {
        return LabelledFormula.of(this.split().eventually(), this.variables());
    }

    public static LabelledSplit of(Split split, List<String> variables) {
        return LabelledSplitTuple.create(split, variables);
    }

    public LabelledFormula toLtl(EnumSet<Robustness> robustness) {
        return LabelledFormula.of(Robustness.buildFormula(this.split(), robustness), this.variables());
    }

    public LabelledSplit map(UnaryOperator<Formula> map) {
        return LabelledSplit.of(this.split().map(map), this.variables());
    }

    public String toString() {
        return "G: " + this.always() + " | FG: " + this.eventuallyAlways() + " | GF: " + this.infinitelyOften() + " | F: " + this.eventually();
    }
}

