/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.naturals.set;

import com.zaxxer.sparsebits.SparseBitSet;
import de.tum.in.naturals.bitset.SparseBitSets;
import de.tum.in.naturals.set.AbstractNatBitSet;
import de.tum.in.naturals.set.NatBitSets;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.NoSuchElementException;
import java.util.function.IntConsumer;

class SparseNatBitSet
extends AbstractNatBitSet {
    private final SparseBitSet bitSet;

    SparseNatBitSet(SparseBitSet bitSet) {
        this.bitSet = bitSet;
    }

    @Override
    public void and(IntCollection indices) {
        if (indices instanceof SparseNatBitSet) {
            SparseNatBitSet other = (SparseNatBitSet)indices;
            this.bitSet.and(other.bitSet);
        } else {
            super.and(indices);
        }
    }

    @Override
    public void andNot(IntCollection indices) {
        if (indices instanceof SparseNatBitSet) {
            SparseNatBitSet other = (SparseNatBitSet)indices;
            this.bitSet.andNot(other.bitSet);
        } else {
            super.andNot(indices);
        }
    }

    @Override
    public void clear(int index) {
        this.bitSet.clear(index);
    }

    @Override
    public void clear(int from, int to) {
        this.bitSet.clear(from, to);
    }

    public void clear() {
        this.bitSet.clear();
    }

    @Override
    public SparseNatBitSet clone() {
        return new SparseNatBitSet(this.bitSet.clone());
    }

    public boolean contains(int index) {
        return 0 <= index && this.bitSet.get(index);
    }

    public boolean containsAll(IntCollection indices) {
        if (indices.isEmpty()) {
            return true;
        }
        if (indices instanceof SparseNatBitSet) {
            SparseNatBitSet other = (SparseNatBitSet)indices;
            SparseBitSet clone = other.bitSet.clone();
            clone.andNot(this.bitSet);
            return clone.isEmpty();
        }
        return super.containsAll(indices);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof SparseNatBitSet) {
            SparseNatBitSet other = (SparseNatBitSet)o;
            return this.bitSet.equals((Object)other.bitSet);
        }
        return super.equals(o);
    }

    @Override
    public void flip(int from, int to) {
        this.bitSet.flip(from, to);
    }

    @Override
    public void flip(int index) {
        this.bitSet.flip(index);
    }

    public void forEach(IntConsumer consumer) {
        SparseBitSets.forEach(this.bitSet, consumer);
    }

    SparseBitSet getSparseBitSet() {
        return this.bitSet;
    }

    public int hashCode() {
        return this.bitSet.hashCode();
    }

    @Override
    public boolean intersects(IntCollection indices) {
        if (indices instanceof SparseNatBitSet) {
            SparseNatBitSet other = (SparseNatBitSet)indices;
            return this.bitSet.intersects(other.bitSet);
        }
        return super.intersects(indices);
    }

    public boolean isEmpty() {
        return this.bitSet.isEmpty();
    }

    @Override
    public IntIterator iterator() {
        return SparseBitSets.iterator(this.bitSet);
    }

    @Override
    public int lastInt() {
        int lastSet = this.bitSet.length() - 1;
        if (lastSet == -1) {
            throw new NoSuchElementException();
        }
        return lastSet;
    }

    @Override
    public int nextAbsentIndex(int index) {
        return this.bitSet.nextClearBit(index);
    }

    @Override
    public int nextPresentIndex(int index) {
        return this.bitSet.nextSetBit(index);
    }

    @Override
    public void or(IntCollection indices) {
        if (indices instanceof SparseNatBitSet) {
            SparseNatBitSet other = (SparseNatBitSet)indices;
            this.bitSet.or(other.bitSet);
        } else {
            super.or(indices);
        }
    }

    @Override
    public int previousAbsentIndex(int index) {
        return NatBitSets.previousAbsentIndex(this.bitSet, index);
    }

    @Override
    public int previousPresentIndex(int index) {
        return NatBitSets.previousPresentIndex(this.bitSet, index);
    }

    @Override
    public void set(int i) {
        this.bitSet.set(i);
    }

    @Override
    public void set(int index, boolean value) {
        this.bitSet.set(index, value);
    }

    @Override
    public void set(int from, int to) {
        this.bitSet.set(from, to);
    }

    public int size() {
        return this.bitSet.cardinality();
    }

    @Override
    public void xor(IntCollection indices) {
        if (indices instanceof SparseNatBitSet) {
            SparseNatBitSet other = (SparseNatBitSet)indices;
            this.bitSet.xor(other.bitSet);
        } else {
            super.xor(indices);
        }
    }
}

