/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.algorithms;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.immutables.value.Generated;
import owl.automaton.algorithms.LanguageMembership;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="LanguageMembership.IndexedState", generator="Immutables")
@Immutable
final class IndexedStateTuple<S>
extends LanguageMembership.IndexedState<S> {
    private final int index;
    private final S state;
    private final transient int hashCode;

    private IndexedStateTuple(int index, S state) {
        this.index = index;
        this.state = Objects.requireNonNull(state, "state");
        this.hashCode = this.computeHashCode();
    }

    @Override
    int index() {
        return this.index;
    }

    @Override
    public S state() {
        return this.state;
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof IndexedStateTuple && this.equalTo((IndexedStateTuple)another);
    }

    private boolean equalTo(IndexedStateTuple<?> another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return this.index == another.index && this.state.equals(another.state);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.index;
        h += (h << 5) + this.state.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"IndexedState").omitNullValues().add("index", this.index).add("state", this.state).toString();
    }

    public static <S> IndexedStateTuple<S> create(int index, S state) {
        return new IndexedStateTuple<S>(index, state);
    }
}

