/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.util;

import java.util.Set;
import owl.automaton.Automaton;
import owl.automaton.MutableAutomaton;
import owl.automaton.MutableAutomatonFactory;
import owl.automaton.Views;
import owl.automaton.acceptance.OmegaAcceptance;
import owl.automaton.algorithms.SccDecomposition;
import owl.automaton.util.AnnotatedState;

public final class AnnotatedStateOptimisation {
    private AnnotatedStateOptimisation() {
    }

    public static <S extends AnnotatedState<?>, A extends OmegaAcceptance> Automaton<S, A> optimizeInitialState(Automaton<S, A> automaton) {
        MutableAutomaton<Object, A> mutableAutomatonCopy = MutableAutomatonFactory.copy(automaton);
        if (mutableAutomatonCopy.initialStates().isEmpty()) {
            return mutableAutomatonCopy;
        }
        Object originalInitialState = ((AnnotatedState)mutableAutomatonCopy.onlyInitialState()).state();
        AnnotatedState candidateInitialState = null;
        int size = mutableAutomatonCopy.size();
        for (Set<S> scc : SccDecomposition.computeSccs(mutableAutomatonCopy, false)) {
            for (AnnotatedState state : scc) {
                int newSize;
                if (!originalInitialState.equals(state.state()) || (newSize = Views.replaceInitialState(mutableAutomatonCopy, Set.of(state)).size()) >= size) continue;
                candidateInitialState = state;
                size = newSize;
            }
        }
        if (candidateInitialState != null) {
            mutableAutomatonCopy.initialStates(Set.of(candidateInitialState));
            mutableAutomatonCopy.trim();
        }
        return mutableAutomatonCopy;
    }
}

