/*
 * Decompiled with CFR 0.152.
 */
package owl.run.modules;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Table;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import owl.automaton.Views;
import owl.automaton.acceptance.optimizations.AcceptanceOptimizations;
import owl.automaton.transformations.ParityUtil;
import owl.automaton.transformations.RabinDegeneralization;
import owl.game.GameUtil;
import owl.game.GameViews;
import owl.ltl.rewriter.SimplifierTransformer;
import owl.ltl.robust.RobustLtlInputReader;
import owl.run.modules.InputReaders;
import owl.run.modules.OutputWriter;
import owl.run.modules.OutputWriters;
import owl.run.modules.OwlModuleParser;
import owl.run.modules.Transformer;
import owl.run.modules.Transformers;
import owl.translations.ExternalTranslator;
import owl.translations.delag.DelagBuilder;
import owl.translations.dra2dpa.IARBuilder;
import owl.translations.fgx2dpa.FGX2DPA;
import owl.translations.modules.LTL2DAModule;
import owl.translations.modules.LTL2DGRAModule;
import owl.translations.modules.LTL2DPAModule;
import owl.translations.modules.LTL2DRAModule;
import owl.translations.modules.LTL2LDBAModule;
import owl.translations.modules.LTL2LDGBAModule;
import owl.translations.modules.LTL2NAModule;
import owl.translations.modules.LTL2NBAModule;
import owl.translations.modules.LTL2NGBAModule;
import owl.translations.nba2dpa.NBA2DPA;
import owl.translations.nba2ldba.NBA2LDBA;

public class OwlModuleRegistry {
    public static final OwlModuleRegistry DEFAULT_REGISTRY = new OwlModuleRegistry();
    private final Table<Type, String, OwlModuleParser<?>> registeredModules = HashBasedTable.create();

    public OwlModuleParser.ReaderParser reader(String name) throws OwlModuleNotFoundException {
        return (OwlModuleParser.ReaderParser)this.getWithType(Type.READER, name);
    }

    public OwlModuleParser.TransformerParser transformer(String name) throws OwlModuleNotFoundException {
        if (this.registeredModules.contains((Object)Type.TRANSFORMER, (Object)name)) {
            return (OwlModuleParser.TransformerParser)this.getWithType(Type.TRANSFORMER, name);
        }
        if (this.registeredModules.contains((Object)Type.WRITER, (Object)name)) {
            OwlModuleParser.WriterParser parser = (OwlModuleParser.WriterParser)this.getWithType(Type.WRITER, name);
            return new AsTransformer(parser);
        }
        throw new OwlModuleNotFoundException(Type.TRANSFORMER, name);
    }

    public OwlModuleParser.WriterParser writer(String name) throws OwlModuleNotFoundException {
        return (OwlModuleParser.WriterParser)this.getWithType(Type.WRITER, name);
    }

    public Collection<OwlModuleParser<?>> getAllOfType(Type type) {
        return this.registeredModules.row((Object)type).values();
    }

    public Map<Type, OwlModuleParser<?>> getAllWithName(String name) {
        return (Map)this.registeredModules.columnMap().get(name);
    }

    private OwlModuleParser<?> getWithType(Type type, String name) throws OwlModuleNotFoundException {
        OwlModuleParser owlModuleParser = (OwlModuleParser)this.registeredModules.get((Object)type, (Object)name);
        if (owlModuleParser == null) {
            throw new OwlModuleNotFoundException(type, name);
        }
        assert (type.typeClass.isInstance(owlModuleParser));
        return owlModuleParser;
    }

    public void register(OwlModuleParser<?> ... parser) {
        for (OwlModuleParser<?> owlModuleParser : parser) {
            this.register(owlModuleParser);
        }
    }

    public void register(OwlModuleParser<?> parser) {
        String name;
        Type type = Type.of(parser);
        if (this.registeredModules.contains((Object)type, (Object)(name = parser.getKey()))) {
            throw new IllegalArgumentException(String.format("Some module with name %s and type %s is already registered", new Object[]{name, type}));
        }
        this.registeredModules.put((Object)type, (Object)name, parser);
    }

    public Set<OwlModuleParser<?>> remove(String name) {
        return new HashSet(((Map)this.registeredModules.columnMap().remove(name)).values());
    }

    static {
        DEFAULT_REGISTRY.register(InputReaders.LTL_CLI, InputReaders.HOA_CLI, OutputWriters.TO_STRING_CLI, OutputWriters.AUTOMATON_STATS_CLI, OutputWriters.NULL_CLI, OutputWriters.HOA_CLI, GameUtil.PG_SOLVER_CLI, RobustLtlInputReader.INSTANCE);
        DEFAULT_REGISTRY.register(SimplifierTransformer.CLI, GameViews.AUTOMATON_TO_GAME_CLI, AcceptanceOptimizations.CLI, RabinDegeneralization.CLI, Views.COMPLETE_CLI);
        DEFAULT_REGISTRY.register(LTL2NBAModule.INSTANCE, LTL2NGBAModule.INSTANCE, LTL2LDBAModule.INSTANCE, LTL2LDGBAModule.INSTANCE, LTL2DRAModule.INSTANCE, LTL2DGRAModule.INSTANCE, LTL2DPAModule.INSTANCE, FGX2DPA.CLI, LTL2DAModule.CLI, DelagBuilder.CLI, LTL2NAModule.CLI, ExternalTranslator.CLI);
        DEFAULT_REGISTRY.register(IARBuilder.CLI, NBA2LDBA.CLI, NBA2DPA.CLI, ParityUtil.COMPLEMENT_CLI, ParityUtil.CONVERSION_CLI);
    }

    private static class AsTransformer
    implements OwlModuleParser.TransformerParser {
        private final OwlModuleParser.WriterParser parser;

        public AsTransformer(OwlModuleParser.WriterParser parser) {
            this.parser = parser;
        }

        @Override
        public String getKey() {
            return this.parser.getKey();
        }

        @Override
        public String getDescription() {
            return this.parser.getDescription();
        }

        @Override
        public Options getOptions() {
            return this.parser.getOptions();
        }

        @Override
        public Transformer parse(CommandLine commandLine) throws ParseException {
            return Transformers.fromWriter((OutputWriter)this.parser.parse(commandLine));
        }
    }

    public static class OwlModuleNotFoundException
    extends Exception {
        public final Type type;
        public final String name;

        OwlModuleNotFoundException(Type type, String name) {
            this.type = type;
            this.name = name;
        }
    }

    public static enum Type {
        READER(OwlModuleParser.ReaderParser.class, "reader"),
        WRITER(OwlModuleParser.WriterParser.class, "writer"),
        TRANSFORMER(OwlModuleParser.TransformerParser.class, "transformer");

        public final Class<?> typeClass;
        public final String name;

        private Type(Class<?> typeClass, String name) {
            this.typeClass = typeClass;
            this.name = name;
        }

        public static Type of(OwlModuleParser<?> object) {
            List types = Arrays.stream(Type.values()).filter(type -> type.typeClass.isInstance(object)).collect(Collectors.toList());
            Preconditions.checkArgument((types.size() == 1 ? 1 : 0) != 0);
            return (Type)((Object)Iterables.getOnlyElement(types));
        }
    }
}

