/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.jbdd;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import de.tum.in.jbdd.BddConfiguration;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Immutable
public final class ImmutableBddConfiguration
extends BddConfiguration {
    private final int cacheBinaryBinsPerHash;
    private final int cacheBinaryDivider;
    private final int cacheComposeDivider;
    private final int cacheSatisfactionBinsPerHash;
    private final int cacheSatisfactionDivider;
    private final int cacheTernaryBinsPerHash;
    private final int cacheTernaryDivider;
    private final int cacheNegationBinsPerHash;
    private final int cacheNegationDivider;
    private final int cacheVolatileBinsPerHash;
    private final int cacheVolatileMultiplier;
    private final int initialVariableNodes;
    private final boolean logStatisticsOnShutdown;
    private final int maximumNodeTableGrowth;
    private final int minimumCacheSize;
    private final int minimumDeadNodesCountForGcInGrow;
    private final int minimumFreeNodeCountAfterGc;
    private final float minimumFreeNodePercentageAfterGc;
    private final int minimumNodeTableGrowth;
    private final int minimumNodeTableSize;
    private final int nodeTableBigThreshold;
    private final int nodeTableSmallThreshold;
    private final boolean useGlobalComposeCache;
    private final boolean useShannonExists;
    private static final int STAGE_INITIALIZING = -1;
    private static final int STAGE_UNINITIALIZED = 0;
    private static final int STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableBddConfiguration(Builder builder) {
        if (builder.cacheBinaryBinsPerHashIsSet()) {
            this.initShim.cacheBinaryBinsPerHash(builder.cacheBinaryBinsPerHash);
        }
        if (builder.cacheBinaryDividerIsSet()) {
            this.initShim.cacheBinaryDivider(builder.cacheBinaryDivider);
        }
        if (builder.cacheComposeDividerIsSet()) {
            this.initShim.cacheComposeDivider(builder.cacheComposeDivider);
        }
        if (builder.cacheSatisfactionBinsPerHashIsSet()) {
            this.initShim.cacheSatisfactionBinsPerHash(builder.cacheSatisfactionBinsPerHash);
        }
        if (builder.cacheSatisfactionDividerIsSet()) {
            this.initShim.cacheSatisfactionDivider(builder.cacheSatisfactionDivider);
        }
        if (builder.cacheTernaryBinsPerHashIsSet()) {
            this.initShim.cacheTernaryBinsPerHash(builder.cacheTernaryBinsPerHash);
        }
        if (builder.cacheTernaryDividerIsSet()) {
            this.initShim.cacheTernaryDivider(builder.cacheTernaryDivider);
        }
        if (builder.cacheNegationBinsPerHashIsSet()) {
            this.initShim.cacheNegationBinsPerHash(builder.cacheNegationBinsPerHash);
        }
        if (builder.cacheNegationDividerIsSet()) {
            this.initShim.cacheNegationDivider(builder.cacheNegationDivider);
        }
        if (builder.cacheVolatileBinsPerHashIsSet()) {
            this.initShim.cacheVolatileBinsPerHash(builder.cacheVolatileBinsPerHash);
        }
        if (builder.cacheVolatileMultiplierIsSet()) {
            this.initShim.cacheVolatileMultiplier(builder.cacheVolatileMultiplier);
        }
        if (builder.initialVariableNodesIsSet()) {
            this.initShim.initialVariableNodes(builder.initialVariableNodes);
        }
        if (builder.logStatisticsOnShutdownIsSet()) {
            this.initShim.logStatisticsOnShutdown(builder.logStatisticsOnShutdown);
        }
        if (builder.maximumNodeTableGrowthIsSet()) {
            this.initShim.maximumNodeTableGrowth(builder.maximumNodeTableGrowth);
        }
        if (builder.minimumCacheSizeIsSet()) {
            this.initShim.minimumCacheSize(builder.minimumCacheSize);
        }
        if (builder.minimumDeadNodesCountForGcInGrowIsSet()) {
            this.initShim.minimumDeadNodesCountForGcInGrow(builder.minimumDeadNodesCountForGcInGrow);
        }
        if (builder.minimumFreeNodeCountAfterGcIsSet()) {
            this.initShim.minimumFreeNodeCountAfterGc(builder.minimumFreeNodeCountAfterGc);
        }
        if (builder.minimumFreeNodePercentageAfterGcIsSet()) {
            this.initShim.minimumFreeNodePercentageAfterGc(builder.minimumFreeNodePercentageAfterGc);
        }
        if (builder.minimumNodeTableGrowthIsSet()) {
            this.initShim.minimumNodeTableGrowth(builder.minimumNodeTableGrowth);
        }
        if (builder.minimumNodeTableSizeIsSet()) {
            this.initShim.minimumNodeTableSize(builder.minimumNodeTableSize);
        }
        if (builder.nodeTableBigThresholdIsSet()) {
            this.initShim.nodeTableBigThreshold(builder.nodeTableBigThreshold);
        }
        if (builder.nodeTableSmallThresholdIsSet()) {
            this.initShim.nodeTableSmallThreshold(builder.nodeTableSmallThreshold);
        }
        if (builder.useGlobalComposeCacheIsSet()) {
            this.initShim.useGlobalComposeCache(builder.useGlobalComposeCache);
        }
        if (builder.useShannonExistsIsSet()) {
            this.initShim.useShannonExists(builder.useShannonExists);
        }
        this.cacheBinaryBinsPerHash = this.initShim.cacheBinaryBinsPerHash();
        this.cacheBinaryDivider = this.initShim.cacheBinaryDivider();
        this.cacheComposeDivider = this.initShim.cacheComposeDivider();
        this.cacheSatisfactionBinsPerHash = this.initShim.cacheSatisfactionBinsPerHash();
        this.cacheSatisfactionDivider = this.initShim.cacheSatisfactionDivider();
        this.cacheTernaryBinsPerHash = this.initShim.cacheTernaryBinsPerHash();
        this.cacheTernaryDivider = this.initShim.cacheTernaryDivider();
        this.cacheNegationBinsPerHash = this.initShim.cacheNegationBinsPerHash();
        this.cacheNegationDivider = this.initShim.cacheNegationDivider();
        this.cacheVolatileBinsPerHash = this.initShim.cacheVolatileBinsPerHash();
        this.cacheVolatileMultiplier = this.initShim.cacheVolatileMultiplier();
        this.initialVariableNodes = this.initShim.initialVariableNodes();
        this.logStatisticsOnShutdown = this.initShim.logStatisticsOnShutdown();
        this.maximumNodeTableGrowth = this.initShim.maximumNodeTableGrowth();
        this.minimumCacheSize = this.initShim.minimumCacheSize();
        this.minimumDeadNodesCountForGcInGrow = this.initShim.minimumDeadNodesCountForGcInGrow();
        this.minimumFreeNodeCountAfterGc = this.initShim.minimumFreeNodeCountAfterGc();
        this.minimumFreeNodePercentageAfterGc = this.initShim.minimumFreeNodePercentageAfterGc();
        this.minimumNodeTableGrowth = this.initShim.minimumNodeTableGrowth();
        this.minimumNodeTableSize = this.initShim.minimumNodeTableSize();
        this.nodeTableBigThreshold = this.initShim.nodeTableBigThreshold();
        this.nodeTableSmallThreshold = this.initShim.nodeTableSmallThreshold();
        this.useGlobalComposeCache = this.initShim.useGlobalComposeCache();
        this.useShannonExists = this.initShim.useShannonExists();
        this.initShim = null;
    }

    private ImmutableBddConfiguration(int cacheBinaryBinsPerHash, int cacheBinaryDivider, int cacheComposeDivider, int cacheSatisfactionBinsPerHash, int cacheSatisfactionDivider, int cacheTernaryBinsPerHash, int cacheTernaryDivider, int cacheNegationBinsPerHash, int cacheNegationDivider, int cacheVolatileBinsPerHash, int cacheVolatileMultiplier, int initialVariableNodes, boolean logStatisticsOnShutdown, int maximumNodeTableGrowth, int minimumCacheSize, int minimumDeadNodesCountForGcInGrow, int minimumFreeNodeCountAfterGc, float minimumFreeNodePercentageAfterGc, int minimumNodeTableGrowth, int minimumNodeTableSize, int nodeTableBigThreshold, int nodeTableSmallThreshold, boolean useGlobalComposeCache, boolean useShannonExists) {
        this.cacheBinaryBinsPerHash = cacheBinaryBinsPerHash;
        this.cacheBinaryDivider = cacheBinaryDivider;
        this.cacheComposeDivider = cacheComposeDivider;
        this.cacheSatisfactionBinsPerHash = cacheSatisfactionBinsPerHash;
        this.cacheSatisfactionDivider = cacheSatisfactionDivider;
        this.cacheTernaryBinsPerHash = cacheTernaryBinsPerHash;
        this.cacheTernaryDivider = cacheTernaryDivider;
        this.cacheNegationBinsPerHash = cacheNegationBinsPerHash;
        this.cacheNegationDivider = cacheNegationDivider;
        this.cacheVolatileBinsPerHash = cacheVolatileBinsPerHash;
        this.cacheVolatileMultiplier = cacheVolatileMultiplier;
        this.initialVariableNodes = initialVariableNodes;
        this.logStatisticsOnShutdown = logStatisticsOnShutdown;
        this.maximumNodeTableGrowth = maximumNodeTableGrowth;
        this.minimumCacheSize = minimumCacheSize;
        this.minimumDeadNodesCountForGcInGrow = minimumDeadNodesCountForGcInGrow;
        this.minimumFreeNodeCountAfterGc = minimumFreeNodeCountAfterGc;
        this.minimumFreeNodePercentageAfterGc = minimumFreeNodePercentageAfterGc;
        this.minimumNodeTableGrowth = minimumNodeTableGrowth;
        this.minimumNodeTableSize = minimumNodeTableSize;
        this.nodeTableBigThreshold = nodeTableBigThreshold;
        this.nodeTableSmallThreshold = nodeTableSmallThreshold;
        this.useGlobalComposeCache = useGlobalComposeCache;
        this.useShannonExists = useShannonExists;
        this.initShim = null;
    }

    @Override
    public int cacheBinaryBinsPerHash() {
        InitShim shim = this.initShim;
        return shim != null ? shim.cacheBinaryBinsPerHash() : this.cacheBinaryBinsPerHash;
    }

    @Override
    public int cacheBinaryDivider() {
        InitShim shim = this.initShim;
        return shim != null ? shim.cacheBinaryDivider() : this.cacheBinaryDivider;
    }

    @Override
    public int cacheComposeDivider() {
        InitShim shim = this.initShim;
        return shim != null ? shim.cacheComposeDivider() : this.cacheComposeDivider;
    }

    @Override
    public int cacheSatisfactionBinsPerHash() {
        InitShim shim = this.initShim;
        return shim != null ? shim.cacheSatisfactionBinsPerHash() : this.cacheSatisfactionBinsPerHash;
    }

    @Override
    public int cacheSatisfactionDivider() {
        InitShim shim = this.initShim;
        return shim != null ? shim.cacheSatisfactionDivider() : this.cacheSatisfactionDivider;
    }

    @Override
    public int cacheTernaryBinsPerHash() {
        InitShim shim = this.initShim;
        return shim != null ? shim.cacheTernaryBinsPerHash() : this.cacheTernaryBinsPerHash;
    }

    @Override
    public int cacheTernaryDivider() {
        InitShim shim = this.initShim;
        return shim != null ? shim.cacheTernaryDivider() : this.cacheTernaryDivider;
    }

    @Override
    public int cacheNegationBinsPerHash() {
        InitShim shim = this.initShim;
        return shim != null ? shim.cacheNegationBinsPerHash() : this.cacheNegationBinsPerHash;
    }

    @Override
    public int cacheNegationDivider() {
        InitShim shim = this.initShim;
        return shim != null ? shim.cacheNegationDivider() : this.cacheNegationDivider;
    }

    @Override
    public int cacheVolatileBinsPerHash() {
        InitShim shim = this.initShim;
        return shim != null ? shim.cacheVolatileBinsPerHash() : this.cacheVolatileBinsPerHash;
    }

    @Override
    public int cacheVolatileMultiplier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.cacheVolatileMultiplier() : this.cacheVolatileMultiplier;
    }

    @Override
    public int initialVariableNodes() {
        InitShim shim = this.initShim;
        return shim != null ? shim.initialVariableNodes() : this.initialVariableNodes;
    }

    @Override
    public boolean logStatisticsOnShutdown() {
        InitShim shim = this.initShim;
        return shim != null ? shim.logStatisticsOnShutdown() : this.logStatisticsOnShutdown;
    }

    @Override
    public int maximumNodeTableGrowth() {
        InitShim shim = this.initShim;
        return shim != null ? shim.maximumNodeTableGrowth() : this.maximumNodeTableGrowth;
    }

    @Override
    public int minimumCacheSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.minimumCacheSize() : this.minimumCacheSize;
    }

    @Override
    public int minimumDeadNodesCountForGcInGrow() {
        InitShim shim = this.initShim;
        return shim != null ? shim.minimumDeadNodesCountForGcInGrow() : this.minimumDeadNodesCountForGcInGrow;
    }

    @Override
    public int minimumFreeNodeCountAfterGc() {
        InitShim shim = this.initShim;
        return shim != null ? shim.minimumFreeNodeCountAfterGc() : this.minimumFreeNodeCountAfterGc;
    }

    @Override
    public float minimumFreeNodePercentageAfterGc() {
        InitShim shim = this.initShim;
        return shim != null ? shim.minimumFreeNodePercentageAfterGc() : this.minimumFreeNodePercentageAfterGc;
    }

    @Override
    public int minimumNodeTableGrowth() {
        InitShim shim = this.initShim;
        return shim != null ? shim.minimumNodeTableGrowth() : this.minimumNodeTableGrowth;
    }

    @Override
    public int minimumNodeTableSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.minimumNodeTableSize() : this.minimumNodeTableSize;
    }

    @Override
    public int nodeTableBigThreshold() {
        InitShim shim = this.initShim;
        return shim != null ? shim.nodeTableBigThreshold() : this.nodeTableBigThreshold;
    }

    @Override
    public int nodeTableSmallThreshold() {
        InitShim shim = this.initShim;
        return shim != null ? shim.nodeTableSmallThreshold() : this.nodeTableSmallThreshold;
    }

    @Override
    public boolean useGlobalComposeCache() {
        InitShim shim = this.initShim;
        return shim != null ? shim.useGlobalComposeCache() : this.useGlobalComposeCache;
    }

    @Override
    public boolean useShannonExists() {
        InitShim shim = this.initShim;
        return shim != null ? shim.useShannonExists() : this.useShannonExists;
    }

    public final ImmutableBddConfiguration withCacheBinaryBinsPerHash(int value) {
        if (this.cacheBinaryBinsPerHash == value) {
            return this;
        }
        return new ImmutableBddConfiguration(value, this.cacheBinaryDivider, this.cacheComposeDivider, this.cacheSatisfactionBinsPerHash, this.cacheSatisfactionDivider, this.cacheTernaryBinsPerHash, this.cacheTernaryDivider, this.cacheNegationBinsPerHash, this.cacheNegationDivider, this.cacheVolatileBinsPerHash, this.cacheVolatileMultiplier, this.initialVariableNodes, this.logStatisticsOnShutdown, this.maximumNodeTableGrowth, this.minimumCacheSize, this.minimumDeadNodesCountForGcInGrow, this.minimumFreeNodeCountAfterGc, this.minimumFreeNodePercentageAfterGc, this.minimumNodeTableGrowth, this.minimumNodeTableSize, this.nodeTableBigThreshold, this.nodeTableSmallThreshold, this.useGlobalComposeCache, this.useShannonExists);
    }

    public final ImmutableBddConfiguration withCacheBinaryDivider(int value) {
        if (this.cacheBinaryDivider == value) {
            return this;
        }
        return new ImmutableBddConfiguration(this.cacheBinaryBinsPerHash, value, this.cacheComposeDivider, this.cacheSatisfactionBinsPerHash, this.cacheSatisfactionDivider, this.cacheTernaryBinsPerHash, this.cacheTernaryDivider, this.cacheNegationBinsPerHash, this.cacheNegationDivider, this.cacheVolatileBinsPerHash, this.cacheVolatileMultiplier, this.initialVariableNodes, this.logStatisticsOnShutdown, this.maximumNodeTableGrowth, this.minimumCacheSize, this.minimumDeadNodesCountForGcInGrow, this.minimumFreeNodeCountAfterGc, this.minimumFreeNodePercentageAfterGc, this.minimumNodeTableGrowth, this.minimumNodeTableSize, this.nodeTableBigThreshold, this.nodeTableSmallThreshold, this.useGlobalComposeCache, this.useShannonExists);
    }

    public final ImmutableBddConfiguration withCacheComposeDivider(int value) {
        if (this.cacheComposeDivider == value) {
            return this;
        }
        return new ImmutableBddConfiguration(this.cacheBinaryBinsPerHash, this.cacheBinaryDivider, value, this.cacheSatisfactionBinsPerHash, this.cacheSatisfactionDivider, this.cacheTernaryBinsPerHash, this.cacheTernaryDivider, this.cacheNegationBinsPerHash, this.cacheNegationDivider, this.cacheVolatileBinsPerHash, this.cacheVolatileMultiplier, this.initialVariableNodes, this.logStatisticsOnShutdown, this.maximumNodeTableGrowth, this.minimumCacheSize, this.minimumDeadNodesCountForGcInGrow, this.minimumFreeNodeCountAfterGc, this.minimumFreeNodePercentageAfterGc, this.minimumNodeTableGrowth, this.minimumNodeTableSize, this.nodeTableBigThreshold, this.nodeTableSmallThreshold, this.useGlobalComposeCache, this.useShannonExists);
    }

    public final ImmutableBddConfiguration withCacheSatisfactionBinsPerHash(int value) {
        if (this.cacheSatisfactionBinsPerHash == value) {
            return this;
        }
        return new ImmutableBddConfiguration(this.cacheBinaryBinsPerHash, this.cacheBinaryDivider, this.cacheComposeDivider, value, this.cacheSatisfactionDivider, this.cacheTernaryBinsPerHash, this.cacheTernaryDivider, this.cacheNegationBinsPerHash, this.cacheNegationDivider, this.cacheVolatileBinsPerHash, this.cacheVolatileMultiplier, this.initialVariableNodes, this.logStatisticsOnShutdown, this.maximumNodeTableGrowth, this.minimumCacheSize, this.minimumDeadNodesCountForGcInGrow, this.minimumFreeNodeCountAfterGc, this.minimumFreeNodePercentageAfterGc, this.minimumNodeTableGrowth, this.minimumNodeTableSize, this.nodeTableBigThreshold, this.nodeTableSmallThreshold, this.useGlobalComposeCache, this.useShannonExists);
    }

    public final ImmutableBddConfiguration withCacheSatisfactionDivider(int value) {
        if (this.cacheSatisfactionDivider == value) {
            return this;
        }
        return new ImmutableBddConfiguration(this.cacheBinaryBinsPerHash, this.cacheBinaryDivider, this.cacheComposeDivider, this.cacheSatisfactionBinsPerHash, value, this.cacheTernaryBinsPerHash, this.cacheTernaryDivider, this.cacheNegationBinsPerHash, this.cacheNegationDivider, this.cacheVolatileBinsPerHash, this.cacheVolatileMultiplier, this.initialVariableNodes, this.logStatisticsOnShutdown, this.maximumNodeTableGrowth, this.minimumCacheSize, this.minimumDeadNodesCountForGcInGrow, this.minimumFreeNodeCountAfterGc, this.minimumFreeNodePercentageAfterGc, this.minimumNodeTableGrowth, this.minimumNodeTableSize, this.nodeTableBigThreshold, this.nodeTableSmallThreshold, this.useGlobalComposeCache, this.useShannonExists);
    }

    public final ImmutableBddConfiguration withCacheTernaryBinsPerHash(int value) {
        if (this.cacheTernaryBinsPerHash == value) {
            return this;
        }
        return new ImmutableBddConfiguration(this.cacheBinaryBinsPerHash, this.cacheBinaryDivider, this.cacheComposeDivider, this.cacheSatisfactionBinsPerHash, this.cacheSatisfactionDivider, value, this.cacheTernaryDivider, this.cacheNegationBinsPerHash, this.cacheNegationDivider, this.cacheVolatileBinsPerHash, this.cacheVolatileMultiplier, this.initialVariableNodes, this.logStatisticsOnShutdown, this.maximumNodeTableGrowth, this.minimumCacheSize, this.minimumDeadNodesCountForGcInGrow, this.minimumFreeNodeCountAfterGc, this.minimumFreeNodePercentageAfterGc, this.minimumNodeTableGrowth, this.minimumNodeTableSize, this.nodeTableBigThreshold, this.nodeTableSmallThreshold, this.useGlobalComposeCache, this.useShannonExists);
    }

    public final ImmutableBddConfiguration withCacheTernaryDivider(int value) {
        if (this.cacheTernaryDivider == value) {
            return this;
        }
        return new ImmutableBddConfiguration(this.cacheBinaryBinsPerHash, this.cacheBinaryDivider, this.cacheComposeDivider, this.cacheSatisfactionBinsPerHash, this.cacheSatisfactionDivider, this.cacheTernaryBinsPerHash, value, this.cacheNegationBinsPerHash, this.cacheNegationDivider, this.cacheVolatileBinsPerHash, this.cacheVolatileMultiplier, this.initialVariableNodes, this.logStatisticsOnShutdown, this.maximumNodeTableGrowth, this.minimumCacheSize, this.minimumDeadNodesCountForGcInGrow, this.minimumFreeNodeCountAfterGc, this.minimumFreeNodePercentageAfterGc, this.minimumNodeTableGrowth, this.minimumNodeTableSize, this.nodeTableBigThreshold, this.nodeTableSmallThreshold, this.useGlobalComposeCache, this.useShannonExists);
    }

    public final ImmutableBddConfiguration withCacheNegationBinsPerHash(int value) {
        if (this.cacheNegationBinsPerHash == value) {
            return this;
        }
        return new ImmutableBddConfiguration(this.cacheBinaryBinsPerHash, this.cacheBinaryDivider, this.cacheComposeDivider, this.cacheSatisfactionBinsPerHash, this.cacheSatisfactionDivider, this.cacheTernaryBinsPerHash, this.cacheTernaryDivider, value, this.cacheNegationDivider, this.cacheVolatileBinsPerHash, this.cacheVolatileMultiplier, this.initialVariableNodes, this.logStatisticsOnShutdown, this.maximumNodeTableGrowth, this.minimumCacheSize, this.minimumDeadNodesCountForGcInGrow, this.minimumFreeNodeCountAfterGc, this.minimumFreeNodePercentageAfterGc, this.minimumNodeTableGrowth, this.minimumNodeTableSize, this.nodeTableBigThreshold, this.nodeTableSmallThreshold, this.useGlobalComposeCache, this.useShannonExists);
    }

    public final ImmutableBddConfiguration withCacheNegationDivider(int value) {
        if (this.cacheNegationDivider == value) {
            return this;
        }
        return new ImmutableBddConfiguration(this.cacheBinaryBinsPerHash, this.cacheBinaryDivider, this.cacheComposeDivider, this.cacheSatisfactionBinsPerHash, this.cacheSatisfactionDivider, this.cacheTernaryBinsPerHash, this.cacheTernaryDivider, this.cacheNegationBinsPerHash, value, this.cacheVolatileBinsPerHash, this.cacheVolatileMultiplier, this.initialVariableNodes, this.logStatisticsOnShutdown, this.maximumNodeTableGrowth, this.minimumCacheSize, this.minimumDeadNodesCountForGcInGrow, this.minimumFreeNodeCountAfterGc, this.minimumFreeNodePercentageAfterGc, this.minimumNodeTableGrowth, this.minimumNodeTableSize, this.nodeTableBigThreshold, this.nodeTableSmallThreshold, this.useGlobalComposeCache, this.useShannonExists);
    }

    public final ImmutableBddConfiguration withCacheVolatileBinsPerHash(int value) {
        if (this.cacheVolatileBinsPerHash == value) {
            return this;
        }
        return new ImmutableBddConfiguration(this.cacheBinaryBinsPerHash, this.cacheBinaryDivider, this.cacheComposeDivider, this.cacheSatisfactionBinsPerHash, this.cacheSatisfactionDivider, this.cacheTernaryBinsPerHash, this.cacheTernaryDivider, this.cacheNegationBinsPerHash, this.cacheNegationDivider, value, this.cacheVolatileMultiplier, this.initialVariableNodes, this.logStatisticsOnShutdown, this.maximumNodeTableGrowth, this.minimumCacheSize, this.minimumDeadNodesCountForGcInGrow, this.minimumFreeNodeCountAfterGc, this.minimumFreeNodePercentageAfterGc, this.minimumNodeTableGrowth, this.minimumNodeTableSize, this.nodeTableBigThreshold, this.nodeTableSmallThreshold, this.useGlobalComposeCache, this.useShannonExists);
    }

    public final ImmutableBddConfiguration withCacheVolatileMultiplier(int value) {
        if (this.cacheVolatileMultiplier == value) {
            return this;
        }
        return new ImmutableBddConfiguration(this.cacheBinaryBinsPerHash, this.cacheBinaryDivider, this.cacheComposeDivider, this.cacheSatisfactionBinsPerHash, this.cacheSatisfactionDivider, this.cacheTernaryBinsPerHash, this.cacheTernaryDivider, this.cacheNegationBinsPerHash, this.cacheNegationDivider, this.cacheVolatileBinsPerHash, value, this.initialVariableNodes, this.logStatisticsOnShutdown, this.maximumNodeTableGrowth, this.minimumCacheSize, this.minimumDeadNodesCountForGcInGrow, this.minimumFreeNodeCountAfterGc, this.minimumFreeNodePercentageAfterGc, this.minimumNodeTableGrowth, this.minimumNodeTableSize, this.nodeTableBigThreshold, this.nodeTableSmallThreshold, this.useGlobalComposeCache, this.useShannonExists);
    }

    public final ImmutableBddConfiguration withInitialVariableNodes(int value) {
        if (this.initialVariableNodes == value) {
            return this;
        }
        return new ImmutableBddConfiguration(this.cacheBinaryBinsPerHash, this.cacheBinaryDivider, this.cacheComposeDivider, this.cacheSatisfactionBinsPerHash, this.cacheSatisfactionDivider, this.cacheTernaryBinsPerHash, this.cacheTernaryDivider, this.cacheNegationBinsPerHash, this.cacheNegationDivider, this.cacheVolatileBinsPerHash, this.cacheVolatileMultiplier, value, this.logStatisticsOnShutdown, this.maximumNodeTableGrowth, this.minimumCacheSize, this.minimumDeadNodesCountForGcInGrow, this.minimumFreeNodeCountAfterGc, this.minimumFreeNodePercentageAfterGc, this.minimumNodeTableGrowth, this.minimumNodeTableSize, this.nodeTableBigThreshold, this.nodeTableSmallThreshold, this.useGlobalComposeCache, this.useShannonExists);
    }

    public final ImmutableBddConfiguration withLogStatisticsOnShutdown(boolean value) {
        if (this.logStatisticsOnShutdown == value) {
            return this;
        }
        return new ImmutableBddConfiguration(this.cacheBinaryBinsPerHash, this.cacheBinaryDivider, this.cacheComposeDivider, this.cacheSatisfactionBinsPerHash, this.cacheSatisfactionDivider, this.cacheTernaryBinsPerHash, this.cacheTernaryDivider, this.cacheNegationBinsPerHash, this.cacheNegationDivider, this.cacheVolatileBinsPerHash, this.cacheVolatileMultiplier, this.initialVariableNodes, value, this.maximumNodeTableGrowth, this.minimumCacheSize, this.minimumDeadNodesCountForGcInGrow, this.minimumFreeNodeCountAfterGc, this.minimumFreeNodePercentageAfterGc, this.minimumNodeTableGrowth, this.minimumNodeTableSize, this.nodeTableBigThreshold, this.nodeTableSmallThreshold, this.useGlobalComposeCache, this.useShannonExists);
    }

    public final ImmutableBddConfiguration withMaximumNodeTableGrowth(int value) {
        if (this.maximumNodeTableGrowth == value) {
            return this;
        }
        return new ImmutableBddConfiguration(this.cacheBinaryBinsPerHash, this.cacheBinaryDivider, this.cacheComposeDivider, this.cacheSatisfactionBinsPerHash, this.cacheSatisfactionDivider, this.cacheTernaryBinsPerHash, this.cacheTernaryDivider, this.cacheNegationBinsPerHash, this.cacheNegationDivider, this.cacheVolatileBinsPerHash, this.cacheVolatileMultiplier, this.initialVariableNodes, this.logStatisticsOnShutdown, value, this.minimumCacheSize, this.minimumDeadNodesCountForGcInGrow, this.minimumFreeNodeCountAfterGc, this.minimumFreeNodePercentageAfterGc, this.minimumNodeTableGrowth, this.minimumNodeTableSize, this.nodeTableBigThreshold, this.nodeTableSmallThreshold, this.useGlobalComposeCache, this.useShannonExists);
    }

    public final ImmutableBddConfiguration withMinimumCacheSize(int value) {
        if (this.minimumCacheSize == value) {
            return this;
        }
        return new ImmutableBddConfiguration(this.cacheBinaryBinsPerHash, this.cacheBinaryDivider, this.cacheComposeDivider, this.cacheSatisfactionBinsPerHash, this.cacheSatisfactionDivider, this.cacheTernaryBinsPerHash, this.cacheTernaryDivider, this.cacheNegationBinsPerHash, this.cacheNegationDivider, this.cacheVolatileBinsPerHash, this.cacheVolatileMultiplier, this.initialVariableNodes, this.logStatisticsOnShutdown, this.maximumNodeTableGrowth, value, this.minimumDeadNodesCountForGcInGrow, this.minimumFreeNodeCountAfterGc, this.minimumFreeNodePercentageAfterGc, this.minimumNodeTableGrowth, this.minimumNodeTableSize, this.nodeTableBigThreshold, this.nodeTableSmallThreshold, this.useGlobalComposeCache, this.useShannonExists);
    }

    public final ImmutableBddConfiguration withMinimumDeadNodesCountForGcInGrow(int value) {
        if (this.minimumDeadNodesCountForGcInGrow == value) {
            return this;
        }
        return new ImmutableBddConfiguration(this.cacheBinaryBinsPerHash, this.cacheBinaryDivider, this.cacheComposeDivider, this.cacheSatisfactionBinsPerHash, this.cacheSatisfactionDivider, this.cacheTernaryBinsPerHash, this.cacheTernaryDivider, this.cacheNegationBinsPerHash, this.cacheNegationDivider, this.cacheVolatileBinsPerHash, this.cacheVolatileMultiplier, this.initialVariableNodes, this.logStatisticsOnShutdown, this.maximumNodeTableGrowth, this.minimumCacheSize, value, this.minimumFreeNodeCountAfterGc, this.minimumFreeNodePercentageAfterGc, this.minimumNodeTableGrowth, this.minimumNodeTableSize, this.nodeTableBigThreshold, this.nodeTableSmallThreshold, this.useGlobalComposeCache, this.useShannonExists);
    }

    public final ImmutableBddConfiguration withMinimumFreeNodeCountAfterGc(int value) {
        if (this.minimumFreeNodeCountAfterGc == value) {
            return this;
        }
        return new ImmutableBddConfiguration(this.cacheBinaryBinsPerHash, this.cacheBinaryDivider, this.cacheComposeDivider, this.cacheSatisfactionBinsPerHash, this.cacheSatisfactionDivider, this.cacheTernaryBinsPerHash, this.cacheTernaryDivider, this.cacheNegationBinsPerHash, this.cacheNegationDivider, this.cacheVolatileBinsPerHash, this.cacheVolatileMultiplier, this.initialVariableNodes, this.logStatisticsOnShutdown, this.maximumNodeTableGrowth, this.minimumCacheSize, this.minimumDeadNodesCountForGcInGrow, value, this.minimumFreeNodePercentageAfterGc, this.minimumNodeTableGrowth, this.minimumNodeTableSize, this.nodeTableBigThreshold, this.nodeTableSmallThreshold, this.useGlobalComposeCache, this.useShannonExists);
    }

    public final ImmutableBddConfiguration withMinimumFreeNodePercentageAfterGc(float value) {
        if (Float.floatToIntBits(this.minimumFreeNodePercentageAfterGc) == Float.floatToIntBits(value)) {
            return this;
        }
        return new ImmutableBddConfiguration(this.cacheBinaryBinsPerHash, this.cacheBinaryDivider, this.cacheComposeDivider, this.cacheSatisfactionBinsPerHash, this.cacheSatisfactionDivider, this.cacheTernaryBinsPerHash, this.cacheTernaryDivider, this.cacheNegationBinsPerHash, this.cacheNegationDivider, this.cacheVolatileBinsPerHash, this.cacheVolatileMultiplier, this.initialVariableNodes, this.logStatisticsOnShutdown, this.maximumNodeTableGrowth, this.minimumCacheSize, this.minimumDeadNodesCountForGcInGrow, this.minimumFreeNodeCountAfterGc, value, this.minimumNodeTableGrowth, this.minimumNodeTableSize, this.nodeTableBigThreshold, this.nodeTableSmallThreshold, this.useGlobalComposeCache, this.useShannonExists);
    }

    public final ImmutableBddConfiguration withMinimumNodeTableGrowth(int value) {
        if (this.minimumNodeTableGrowth == value) {
            return this;
        }
        return new ImmutableBddConfiguration(this.cacheBinaryBinsPerHash, this.cacheBinaryDivider, this.cacheComposeDivider, this.cacheSatisfactionBinsPerHash, this.cacheSatisfactionDivider, this.cacheTernaryBinsPerHash, this.cacheTernaryDivider, this.cacheNegationBinsPerHash, this.cacheNegationDivider, this.cacheVolatileBinsPerHash, this.cacheVolatileMultiplier, this.initialVariableNodes, this.logStatisticsOnShutdown, this.maximumNodeTableGrowth, this.minimumCacheSize, this.minimumDeadNodesCountForGcInGrow, this.minimumFreeNodeCountAfterGc, this.minimumFreeNodePercentageAfterGc, value, this.minimumNodeTableSize, this.nodeTableBigThreshold, this.nodeTableSmallThreshold, this.useGlobalComposeCache, this.useShannonExists);
    }

    public final ImmutableBddConfiguration withMinimumNodeTableSize(int value) {
        if (this.minimumNodeTableSize == value) {
            return this;
        }
        return new ImmutableBddConfiguration(this.cacheBinaryBinsPerHash, this.cacheBinaryDivider, this.cacheComposeDivider, this.cacheSatisfactionBinsPerHash, this.cacheSatisfactionDivider, this.cacheTernaryBinsPerHash, this.cacheTernaryDivider, this.cacheNegationBinsPerHash, this.cacheNegationDivider, this.cacheVolatileBinsPerHash, this.cacheVolatileMultiplier, this.initialVariableNodes, this.logStatisticsOnShutdown, this.maximumNodeTableGrowth, this.minimumCacheSize, this.minimumDeadNodesCountForGcInGrow, this.minimumFreeNodeCountAfterGc, this.minimumFreeNodePercentageAfterGc, this.minimumNodeTableGrowth, value, this.nodeTableBigThreshold, this.nodeTableSmallThreshold, this.useGlobalComposeCache, this.useShannonExists);
    }

    public final ImmutableBddConfiguration withNodeTableBigThreshold(int value) {
        if (this.nodeTableBigThreshold == value) {
            return this;
        }
        return new ImmutableBddConfiguration(this.cacheBinaryBinsPerHash, this.cacheBinaryDivider, this.cacheComposeDivider, this.cacheSatisfactionBinsPerHash, this.cacheSatisfactionDivider, this.cacheTernaryBinsPerHash, this.cacheTernaryDivider, this.cacheNegationBinsPerHash, this.cacheNegationDivider, this.cacheVolatileBinsPerHash, this.cacheVolatileMultiplier, this.initialVariableNodes, this.logStatisticsOnShutdown, this.maximumNodeTableGrowth, this.minimumCacheSize, this.minimumDeadNodesCountForGcInGrow, this.minimumFreeNodeCountAfterGc, this.minimumFreeNodePercentageAfterGc, this.minimumNodeTableGrowth, this.minimumNodeTableSize, value, this.nodeTableSmallThreshold, this.useGlobalComposeCache, this.useShannonExists);
    }

    public final ImmutableBddConfiguration withNodeTableSmallThreshold(int value) {
        if (this.nodeTableSmallThreshold == value) {
            return this;
        }
        return new ImmutableBddConfiguration(this.cacheBinaryBinsPerHash, this.cacheBinaryDivider, this.cacheComposeDivider, this.cacheSatisfactionBinsPerHash, this.cacheSatisfactionDivider, this.cacheTernaryBinsPerHash, this.cacheTernaryDivider, this.cacheNegationBinsPerHash, this.cacheNegationDivider, this.cacheVolatileBinsPerHash, this.cacheVolatileMultiplier, this.initialVariableNodes, this.logStatisticsOnShutdown, this.maximumNodeTableGrowth, this.minimumCacheSize, this.minimumDeadNodesCountForGcInGrow, this.minimumFreeNodeCountAfterGc, this.minimumFreeNodePercentageAfterGc, this.minimumNodeTableGrowth, this.minimumNodeTableSize, this.nodeTableBigThreshold, value, this.useGlobalComposeCache, this.useShannonExists);
    }

    public final ImmutableBddConfiguration withUseGlobalComposeCache(boolean value) {
        if (this.useGlobalComposeCache == value) {
            return this;
        }
        return new ImmutableBddConfiguration(this.cacheBinaryBinsPerHash, this.cacheBinaryDivider, this.cacheComposeDivider, this.cacheSatisfactionBinsPerHash, this.cacheSatisfactionDivider, this.cacheTernaryBinsPerHash, this.cacheTernaryDivider, this.cacheNegationBinsPerHash, this.cacheNegationDivider, this.cacheVolatileBinsPerHash, this.cacheVolatileMultiplier, this.initialVariableNodes, this.logStatisticsOnShutdown, this.maximumNodeTableGrowth, this.minimumCacheSize, this.minimumDeadNodesCountForGcInGrow, this.minimumFreeNodeCountAfterGc, this.minimumFreeNodePercentageAfterGc, this.minimumNodeTableGrowth, this.minimumNodeTableSize, this.nodeTableBigThreshold, this.nodeTableSmallThreshold, value, this.useShannonExists);
    }

    public final ImmutableBddConfiguration withUseShannonExists(boolean value) {
        if (this.useShannonExists == value) {
            return this;
        }
        return new ImmutableBddConfiguration(this.cacheBinaryBinsPerHash, this.cacheBinaryDivider, this.cacheComposeDivider, this.cacheSatisfactionBinsPerHash, this.cacheSatisfactionDivider, this.cacheTernaryBinsPerHash, this.cacheTernaryDivider, this.cacheNegationBinsPerHash, this.cacheNegationDivider, this.cacheVolatileBinsPerHash, this.cacheVolatileMultiplier, this.initialVariableNodes, this.logStatisticsOnShutdown, this.maximumNodeTableGrowth, this.minimumCacheSize, this.minimumDeadNodesCountForGcInGrow, this.minimumFreeNodeCountAfterGc, this.minimumFreeNodePercentageAfterGc, this.minimumNodeTableGrowth, this.minimumNodeTableSize, this.nodeTableBigThreshold, this.nodeTableSmallThreshold, this.useGlobalComposeCache, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBddConfiguration && this.equalTo((ImmutableBddConfiguration)another);
    }

    private boolean equalTo(ImmutableBddConfiguration another) {
        return this.cacheBinaryBinsPerHash == another.cacheBinaryBinsPerHash && this.cacheBinaryDivider == another.cacheBinaryDivider && this.cacheComposeDivider == another.cacheComposeDivider && this.cacheSatisfactionBinsPerHash == another.cacheSatisfactionBinsPerHash && this.cacheSatisfactionDivider == another.cacheSatisfactionDivider && this.cacheTernaryBinsPerHash == another.cacheTernaryBinsPerHash && this.cacheTernaryDivider == another.cacheTernaryDivider && this.cacheNegationBinsPerHash == another.cacheNegationBinsPerHash && this.cacheNegationDivider == another.cacheNegationDivider && this.cacheVolatileBinsPerHash == another.cacheVolatileBinsPerHash && this.cacheVolatileMultiplier == another.cacheVolatileMultiplier && this.initialVariableNodes == another.initialVariableNodes && this.logStatisticsOnShutdown == another.logStatisticsOnShutdown && this.maximumNodeTableGrowth == another.maximumNodeTableGrowth && this.minimumCacheSize == another.minimumCacheSize && this.minimumDeadNodesCountForGcInGrow == another.minimumDeadNodesCountForGcInGrow && this.minimumFreeNodeCountAfterGc == another.minimumFreeNodeCountAfterGc && Float.floatToIntBits(this.minimumFreeNodePercentageAfterGc) == Float.floatToIntBits(another.minimumFreeNodePercentageAfterGc) && this.minimumNodeTableGrowth == another.minimumNodeTableGrowth && this.minimumNodeTableSize == another.minimumNodeTableSize && this.nodeTableBigThreshold == another.nodeTableBigThreshold && this.nodeTableSmallThreshold == another.nodeTableSmallThreshold && this.useGlobalComposeCache == another.useGlobalComposeCache && this.useShannonExists == another.useShannonExists;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.cacheBinaryBinsPerHash;
        h += (h << 5) + this.cacheBinaryDivider;
        h += (h << 5) + this.cacheComposeDivider;
        h += (h << 5) + this.cacheSatisfactionBinsPerHash;
        h += (h << 5) + this.cacheSatisfactionDivider;
        h += (h << 5) + this.cacheTernaryBinsPerHash;
        h += (h << 5) + this.cacheTernaryDivider;
        h += (h << 5) + this.cacheNegationBinsPerHash;
        h += (h << 5) + this.cacheNegationDivider;
        h += (h << 5) + this.cacheVolatileBinsPerHash;
        h += (h << 5) + this.cacheVolatileMultiplier;
        h += (h << 5) + this.initialVariableNodes;
        h += (h << 5) + Boolean.hashCode(this.logStatisticsOnShutdown);
        h += (h << 5) + this.maximumNodeTableGrowth;
        h += (h << 5) + this.minimumCacheSize;
        h += (h << 5) + this.minimumDeadNodesCountForGcInGrow;
        h += (h << 5) + this.minimumFreeNodeCountAfterGc;
        h += (h << 5) + Float.hashCode(this.minimumFreeNodePercentageAfterGc);
        h += (h << 5) + this.minimumNodeTableGrowth;
        h += (h << 5) + this.minimumNodeTableSize;
        h += (h << 5) + this.nodeTableBigThreshold;
        h += (h << 5) + this.nodeTableSmallThreshold;
        h += (h << 5) + Boolean.hashCode(this.useGlobalComposeCache);
        h += (h << 5) + Boolean.hashCode(this.useShannonExists);
        return h;
    }

    public String toString() {
        return "BddConfiguration{cacheBinaryBinsPerHash=" + this.cacheBinaryBinsPerHash + ", cacheBinaryDivider=" + this.cacheBinaryDivider + ", cacheComposeDivider=" + this.cacheComposeDivider + ", cacheSatisfactionBinsPerHash=" + this.cacheSatisfactionBinsPerHash + ", cacheSatisfactionDivider=" + this.cacheSatisfactionDivider + ", cacheTernaryBinsPerHash=" + this.cacheTernaryBinsPerHash + ", cacheTernaryDivider=" + this.cacheTernaryDivider + ", cacheNegationBinsPerHash=" + this.cacheNegationBinsPerHash + ", cacheNegationDivider=" + this.cacheNegationDivider + ", cacheVolatileBinsPerHash=" + this.cacheVolatileBinsPerHash + ", cacheVolatileMultiplier=" + this.cacheVolatileMultiplier + ", initialVariableNodes=" + this.initialVariableNodes + ", logStatisticsOnShutdown=" + this.logStatisticsOnShutdown + ", maximumNodeTableGrowth=" + this.maximumNodeTableGrowth + ", minimumCacheSize=" + this.minimumCacheSize + ", minimumDeadNodesCountForGcInGrow=" + this.minimumDeadNodesCountForGcInGrow + ", minimumFreeNodeCountAfterGc=" + this.minimumFreeNodeCountAfterGc + ", minimumFreeNodePercentageAfterGc=" + this.minimumFreeNodePercentageAfterGc + ", minimumNodeTableGrowth=" + this.minimumNodeTableGrowth + ", minimumNodeTableSize=" + this.minimumNodeTableSize + ", nodeTableBigThreshold=" + this.nodeTableBigThreshold + ", nodeTableSmallThreshold=" + this.nodeTableSmallThreshold + ", useGlobalComposeCache=" + this.useGlobalComposeCache + ", useShannonExists=" + this.useShannonExists + "}";
    }

    public static ImmutableBddConfiguration copyOf(BddConfiguration instance) {
        if (instance instanceof ImmutableBddConfiguration) {
            return (ImmutableBddConfiguration)instance;
        }
        return ImmutableBddConfiguration.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_CACHE_BINARY_BINS_PER_HASH = 1L;
        private static final long OPT_BIT_CACHE_BINARY_DIVIDER = 2L;
        private static final long OPT_BIT_CACHE_COMPOSE_DIVIDER = 4L;
        private static final long OPT_BIT_CACHE_SATISFACTION_BINS_PER_HASH = 8L;
        private static final long OPT_BIT_CACHE_SATISFACTION_DIVIDER = 16L;
        private static final long OPT_BIT_CACHE_TERNARY_BINS_PER_HASH = 32L;
        private static final long OPT_BIT_CACHE_TERNARY_DIVIDER = 64L;
        private static final long OPT_BIT_CACHE_NEGATION_BINS_PER_HASH = 128L;
        private static final long OPT_BIT_CACHE_NEGATION_DIVIDER = 256L;
        private static final long OPT_BIT_CACHE_VOLATILE_BINS_PER_HASH = 512L;
        private static final long OPT_BIT_CACHE_VOLATILE_MULTIPLIER = 1024L;
        private static final long OPT_BIT_INITIAL_VARIABLE_NODES = 2048L;
        private static final long OPT_BIT_LOG_STATISTICS_ON_SHUTDOWN = 4096L;
        private static final long OPT_BIT_MAXIMUM_NODE_TABLE_GROWTH = 8192L;
        private static final long OPT_BIT_MINIMUM_CACHE_SIZE = 16384L;
        private static final long OPT_BIT_MINIMUM_DEAD_NODES_COUNT_FOR_GC_IN_GROW = 32768L;
        private static final long OPT_BIT_MINIMUM_FREE_NODE_COUNT_AFTER_GC = 65536L;
        private static final long OPT_BIT_MINIMUM_FREE_NODE_PERCENTAGE_AFTER_GC = 131072L;
        private static final long OPT_BIT_MINIMUM_NODE_TABLE_GROWTH = 262144L;
        private static final long OPT_BIT_MINIMUM_NODE_TABLE_SIZE = 524288L;
        private static final long OPT_BIT_NODE_TABLE_BIG_THRESHOLD = 0x100000L;
        private static final long OPT_BIT_NODE_TABLE_SMALL_THRESHOLD = 0x200000L;
        private static final long OPT_BIT_USE_GLOBAL_COMPOSE_CACHE = 0x400000L;
        private static final long OPT_BIT_USE_SHANNON_EXISTS = 0x800000L;
        private long optBits;
        private int cacheBinaryBinsPerHash;
        private int cacheBinaryDivider;
        private int cacheComposeDivider;
        private int cacheSatisfactionBinsPerHash;
        private int cacheSatisfactionDivider;
        private int cacheTernaryBinsPerHash;
        private int cacheTernaryDivider;
        private int cacheNegationBinsPerHash;
        private int cacheNegationDivider;
        private int cacheVolatileBinsPerHash;
        private int cacheVolatileMultiplier;
        private int initialVariableNodes;
        private boolean logStatisticsOnShutdown;
        private int maximumNodeTableGrowth;
        private int minimumCacheSize;
        private int minimumDeadNodesCountForGcInGrow;
        private int minimumFreeNodeCountAfterGc;
        private float minimumFreeNodePercentageAfterGc;
        private int minimumNodeTableGrowth;
        private int minimumNodeTableSize;
        private int nodeTableBigThreshold;
        private int nodeTableSmallThreshold;
        private boolean useGlobalComposeCache;
        private boolean useShannonExists;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(BddConfiguration instance) {
            Objects.requireNonNull(instance, "instance");
            this.cacheBinaryBinsPerHash(instance.cacheBinaryBinsPerHash());
            this.cacheBinaryDivider(instance.cacheBinaryDivider());
            this.cacheComposeDivider(instance.cacheComposeDivider());
            this.cacheSatisfactionBinsPerHash(instance.cacheSatisfactionBinsPerHash());
            this.cacheSatisfactionDivider(instance.cacheSatisfactionDivider());
            this.cacheTernaryBinsPerHash(instance.cacheTernaryBinsPerHash());
            this.cacheTernaryDivider(instance.cacheTernaryDivider());
            this.cacheNegationBinsPerHash(instance.cacheNegationBinsPerHash());
            this.cacheNegationDivider(instance.cacheNegationDivider());
            this.cacheVolatileBinsPerHash(instance.cacheVolatileBinsPerHash());
            this.cacheVolatileMultiplier(instance.cacheVolatileMultiplier());
            this.initialVariableNodes(instance.initialVariableNodes());
            this.logStatisticsOnShutdown(instance.logStatisticsOnShutdown());
            this.maximumNodeTableGrowth(instance.maximumNodeTableGrowth());
            this.minimumCacheSize(instance.minimumCacheSize());
            this.minimumDeadNodesCountForGcInGrow(instance.minimumDeadNodesCountForGcInGrow());
            this.minimumFreeNodeCountAfterGc(instance.minimumFreeNodeCountAfterGc());
            this.minimumFreeNodePercentageAfterGc(instance.minimumFreeNodePercentageAfterGc());
            this.minimumNodeTableGrowth(instance.minimumNodeTableGrowth());
            this.minimumNodeTableSize(instance.minimumNodeTableSize());
            this.nodeTableBigThreshold(instance.nodeTableBigThreshold());
            this.nodeTableSmallThreshold(instance.nodeTableSmallThreshold());
            this.useGlobalComposeCache(instance.useGlobalComposeCache());
            this.useShannonExists(instance.useShannonExists());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder cacheBinaryBinsPerHash(int cacheBinaryBinsPerHash) {
            this.cacheBinaryBinsPerHash = cacheBinaryBinsPerHash;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder cacheBinaryDivider(int cacheBinaryDivider) {
            this.cacheBinaryDivider = cacheBinaryDivider;
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder cacheComposeDivider(int cacheComposeDivider) {
            this.cacheComposeDivider = cacheComposeDivider;
            this.optBits |= 4L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder cacheSatisfactionBinsPerHash(int cacheSatisfactionBinsPerHash) {
            this.cacheSatisfactionBinsPerHash = cacheSatisfactionBinsPerHash;
            this.optBits |= 8L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder cacheSatisfactionDivider(int cacheSatisfactionDivider) {
            this.cacheSatisfactionDivider = cacheSatisfactionDivider;
            this.optBits |= 0x10L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder cacheTernaryBinsPerHash(int cacheTernaryBinsPerHash) {
            this.cacheTernaryBinsPerHash = cacheTernaryBinsPerHash;
            this.optBits |= 0x20L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder cacheTernaryDivider(int cacheTernaryDivider) {
            this.cacheTernaryDivider = cacheTernaryDivider;
            this.optBits |= 0x40L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder cacheNegationBinsPerHash(int cacheNegationBinsPerHash) {
            this.cacheNegationBinsPerHash = cacheNegationBinsPerHash;
            this.optBits |= 0x80L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder cacheNegationDivider(int cacheNegationDivider) {
            this.cacheNegationDivider = cacheNegationDivider;
            this.optBits |= 0x100L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder cacheVolatileBinsPerHash(int cacheVolatileBinsPerHash) {
            this.cacheVolatileBinsPerHash = cacheVolatileBinsPerHash;
            this.optBits |= 0x200L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder cacheVolatileMultiplier(int cacheVolatileMultiplier) {
            this.cacheVolatileMultiplier = cacheVolatileMultiplier;
            this.optBits |= 0x400L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder initialVariableNodes(int initialVariableNodes) {
            this.initialVariableNodes = initialVariableNodes;
            this.optBits |= 0x800L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder logStatisticsOnShutdown(boolean logStatisticsOnShutdown) {
            this.logStatisticsOnShutdown = logStatisticsOnShutdown;
            this.optBits |= 0x1000L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder maximumNodeTableGrowth(int maximumNodeTableGrowth) {
            this.maximumNodeTableGrowth = maximumNodeTableGrowth;
            this.optBits |= 0x2000L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder minimumCacheSize(int minimumCacheSize) {
            this.minimumCacheSize = minimumCacheSize;
            this.optBits |= 0x4000L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder minimumDeadNodesCountForGcInGrow(int minimumDeadNodesCountForGcInGrow) {
            this.minimumDeadNodesCountForGcInGrow = minimumDeadNodesCountForGcInGrow;
            this.optBits |= 0x8000L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder minimumFreeNodeCountAfterGc(int minimumFreeNodeCountAfterGc) {
            this.minimumFreeNodeCountAfterGc = minimumFreeNodeCountAfterGc;
            this.optBits |= 0x10000L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder minimumFreeNodePercentageAfterGc(float minimumFreeNodePercentageAfterGc) {
            this.minimumFreeNodePercentageAfterGc = minimumFreeNodePercentageAfterGc;
            this.optBits |= 0x20000L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder minimumNodeTableGrowth(int minimumNodeTableGrowth) {
            this.minimumNodeTableGrowth = minimumNodeTableGrowth;
            this.optBits |= 0x40000L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder minimumNodeTableSize(int minimumNodeTableSize) {
            this.minimumNodeTableSize = minimumNodeTableSize;
            this.optBits |= 0x80000L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder nodeTableBigThreshold(int nodeTableBigThreshold) {
            this.nodeTableBigThreshold = nodeTableBigThreshold;
            this.optBits |= 0x100000L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder nodeTableSmallThreshold(int nodeTableSmallThreshold) {
            this.nodeTableSmallThreshold = nodeTableSmallThreshold;
            this.optBits |= 0x200000L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder useGlobalComposeCache(boolean useGlobalComposeCache) {
            this.useGlobalComposeCache = useGlobalComposeCache;
            this.optBits |= 0x400000L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder useShannonExists(boolean useShannonExists) {
            this.useShannonExists = useShannonExists;
            this.optBits |= 0x800000L;
            return this;
        }

        public ImmutableBddConfiguration build() {
            return new ImmutableBddConfiguration(this);
        }

        private boolean cacheBinaryBinsPerHashIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean cacheBinaryDividerIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean cacheComposeDividerIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean cacheSatisfactionBinsPerHashIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean cacheSatisfactionDividerIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean cacheTernaryBinsPerHashIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean cacheTernaryDividerIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private boolean cacheNegationBinsPerHashIsSet() {
            return (this.optBits & 0x80L) != 0L;
        }

        private boolean cacheNegationDividerIsSet() {
            return (this.optBits & 0x100L) != 0L;
        }

        private boolean cacheVolatileBinsPerHashIsSet() {
            return (this.optBits & 0x200L) != 0L;
        }

        private boolean cacheVolatileMultiplierIsSet() {
            return (this.optBits & 0x400L) != 0L;
        }

        private boolean initialVariableNodesIsSet() {
            return (this.optBits & 0x800L) != 0L;
        }

        private boolean logStatisticsOnShutdownIsSet() {
            return (this.optBits & 0x1000L) != 0L;
        }

        private boolean maximumNodeTableGrowthIsSet() {
            return (this.optBits & 0x2000L) != 0L;
        }

        private boolean minimumCacheSizeIsSet() {
            return (this.optBits & 0x4000L) != 0L;
        }

        private boolean minimumDeadNodesCountForGcInGrowIsSet() {
            return (this.optBits & 0x8000L) != 0L;
        }

        private boolean minimumFreeNodeCountAfterGcIsSet() {
            return (this.optBits & 0x10000L) != 0L;
        }

        private boolean minimumFreeNodePercentageAfterGcIsSet() {
            return (this.optBits & 0x20000L) != 0L;
        }

        private boolean minimumNodeTableGrowthIsSet() {
            return (this.optBits & 0x40000L) != 0L;
        }

        private boolean minimumNodeTableSizeIsSet() {
            return (this.optBits & 0x80000L) != 0L;
        }

        private boolean nodeTableBigThresholdIsSet() {
            return (this.optBits & 0x100000L) != 0L;
        }

        private boolean nodeTableSmallThresholdIsSet() {
            return (this.optBits & 0x200000L) != 0L;
        }

        private boolean useGlobalComposeCacheIsSet() {
            return (this.optBits & 0x400000L) != 0L;
        }

        private boolean useShannonExistsIsSet() {
            return (this.optBits & 0x800000L) != 0L;
        }
    }

    private final class InitShim {
        private int cacheBinaryBinsPerHash;
        private int cacheBinaryBinsPerHashBuildStage;
        private int cacheBinaryDivider;
        private int cacheBinaryDividerBuildStage;
        private int cacheComposeDivider;
        private int cacheComposeDividerBuildStage;
        private int cacheSatisfactionBinsPerHash;
        private int cacheSatisfactionBinsPerHashBuildStage;
        private int cacheSatisfactionDivider;
        private int cacheSatisfactionDividerBuildStage;
        private int cacheTernaryBinsPerHash;
        private int cacheTernaryBinsPerHashBuildStage;
        private int cacheTernaryDivider;
        private int cacheTernaryDividerBuildStage;
        private int cacheNegationBinsPerHash;
        private int cacheNegationBinsPerHashBuildStage;
        private int cacheNegationDivider;
        private int cacheNegationDividerBuildStage;
        private int cacheVolatileBinsPerHash;
        private int cacheVolatileBinsPerHashBuildStage;
        private int cacheVolatileMultiplier;
        private int cacheVolatileMultiplierBuildStage;
        private int initialVariableNodes;
        private int initialVariableNodesBuildStage;
        private boolean logStatisticsOnShutdown;
        private int logStatisticsOnShutdownBuildStage;
        private int maximumNodeTableGrowth;
        private int maximumNodeTableGrowthBuildStage;
        private int minimumCacheSize;
        private int minimumCacheSizeBuildStage;
        private int minimumDeadNodesCountForGcInGrow;
        private int minimumDeadNodesCountForGcInGrowBuildStage;
        private int minimumFreeNodeCountAfterGc;
        private int minimumFreeNodeCountAfterGcBuildStage;
        private float minimumFreeNodePercentageAfterGc;
        private int minimumFreeNodePercentageAfterGcBuildStage;
        private int minimumNodeTableGrowth;
        private int minimumNodeTableGrowthBuildStage;
        private int minimumNodeTableSize;
        private int minimumNodeTableSizeBuildStage;
        private int nodeTableBigThreshold;
        private int nodeTableBigThresholdBuildStage;
        private int nodeTableSmallThreshold;
        private int nodeTableSmallThresholdBuildStage;
        private boolean useGlobalComposeCache;
        private int useGlobalComposeCacheBuildStage;
        private boolean useShannonExists;
        private int useShannonExistsBuildStage;

        private InitShim() {
        }

        int cacheBinaryBinsPerHash() {
            if (this.cacheBinaryBinsPerHashBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.cacheBinaryBinsPerHashBuildStage == 0) {
                this.cacheBinaryBinsPerHashBuildStage = -1;
                this.cacheBinaryBinsPerHash = ImmutableBddConfiguration.super.cacheBinaryBinsPerHash();
                this.cacheBinaryBinsPerHashBuildStage = 1;
            }
            return this.cacheBinaryBinsPerHash;
        }

        void cacheBinaryBinsPerHash(int cacheBinaryBinsPerHash) {
            this.cacheBinaryBinsPerHash = cacheBinaryBinsPerHash;
            this.cacheBinaryBinsPerHashBuildStage = 1;
        }

        int cacheBinaryDivider() {
            if (this.cacheBinaryDividerBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.cacheBinaryDividerBuildStage == 0) {
                this.cacheBinaryDividerBuildStage = -1;
                this.cacheBinaryDivider = ImmutableBddConfiguration.super.cacheBinaryDivider();
                this.cacheBinaryDividerBuildStage = 1;
            }
            return this.cacheBinaryDivider;
        }

        void cacheBinaryDivider(int cacheBinaryDivider) {
            this.cacheBinaryDivider = cacheBinaryDivider;
            this.cacheBinaryDividerBuildStage = 1;
        }

        int cacheComposeDivider() {
            if (this.cacheComposeDividerBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.cacheComposeDividerBuildStage == 0) {
                this.cacheComposeDividerBuildStage = -1;
                this.cacheComposeDivider = ImmutableBddConfiguration.super.cacheComposeDivider();
                this.cacheComposeDividerBuildStage = 1;
            }
            return this.cacheComposeDivider;
        }

        void cacheComposeDivider(int cacheComposeDivider) {
            this.cacheComposeDivider = cacheComposeDivider;
            this.cacheComposeDividerBuildStage = 1;
        }

        int cacheSatisfactionBinsPerHash() {
            if (this.cacheSatisfactionBinsPerHashBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.cacheSatisfactionBinsPerHashBuildStage == 0) {
                this.cacheSatisfactionBinsPerHashBuildStage = -1;
                this.cacheSatisfactionBinsPerHash = ImmutableBddConfiguration.super.cacheSatisfactionBinsPerHash();
                this.cacheSatisfactionBinsPerHashBuildStage = 1;
            }
            return this.cacheSatisfactionBinsPerHash;
        }

        void cacheSatisfactionBinsPerHash(int cacheSatisfactionBinsPerHash) {
            this.cacheSatisfactionBinsPerHash = cacheSatisfactionBinsPerHash;
            this.cacheSatisfactionBinsPerHashBuildStage = 1;
        }

        int cacheSatisfactionDivider() {
            if (this.cacheSatisfactionDividerBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.cacheSatisfactionDividerBuildStage == 0) {
                this.cacheSatisfactionDividerBuildStage = -1;
                this.cacheSatisfactionDivider = ImmutableBddConfiguration.super.cacheSatisfactionDivider();
                this.cacheSatisfactionDividerBuildStage = 1;
            }
            return this.cacheSatisfactionDivider;
        }

        void cacheSatisfactionDivider(int cacheSatisfactionDivider) {
            this.cacheSatisfactionDivider = cacheSatisfactionDivider;
            this.cacheSatisfactionDividerBuildStage = 1;
        }

        int cacheTernaryBinsPerHash() {
            if (this.cacheTernaryBinsPerHashBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.cacheTernaryBinsPerHashBuildStage == 0) {
                this.cacheTernaryBinsPerHashBuildStage = -1;
                this.cacheTernaryBinsPerHash = ImmutableBddConfiguration.super.cacheTernaryBinsPerHash();
                this.cacheTernaryBinsPerHashBuildStage = 1;
            }
            return this.cacheTernaryBinsPerHash;
        }

        void cacheTernaryBinsPerHash(int cacheTernaryBinsPerHash) {
            this.cacheTernaryBinsPerHash = cacheTernaryBinsPerHash;
            this.cacheTernaryBinsPerHashBuildStage = 1;
        }

        int cacheTernaryDivider() {
            if (this.cacheTernaryDividerBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.cacheTernaryDividerBuildStage == 0) {
                this.cacheTernaryDividerBuildStage = -1;
                this.cacheTernaryDivider = ImmutableBddConfiguration.super.cacheTernaryDivider();
                this.cacheTernaryDividerBuildStage = 1;
            }
            return this.cacheTernaryDivider;
        }

        void cacheTernaryDivider(int cacheTernaryDivider) {
            this.cacheTernaryDivider = cacheTernaryDivider;
            this.cacheTernaryDividerBuildStage = 1;
        }

        int cacheNegationBinsPerHash() {
            if (this.cacheNegationBinsPerHashBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.cacheNegationBinsPerHashBuildStage == 0) {
                this.cacheNegationBinsPerHashBuildStage = -1;
                this.cacheNegationBinsPerHash = ImmutableBddConfiguration.super.cacheNegationBinsPerHash();
                this.cacheNegationBinsPerHashBuildStage = 1;
            }
            return this.cacheNegationBinsPerHash;
        }

        void cacheNegationBinsPerHash(int cacheNegationBinsPerHash) {
            this.cacheNegationBinsPerHash = cacheNegationBinsPerHash;
            this.cacheNegationBinsPerHashBuildStage = 1;
        }

        int cacheNegationDivider() {
            if (this.cacheNegationDividerBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.cacheNegationDividerBuildStage == 0) {
                this.cacheNegationDividerBuildStage = -1;
                this.cacheNegationDivider = ImmutableBddConfiguration.super.cacheNegationDivider();
                this.cacheNegationDividerBuildStage = 1;
            }
            return this.cacheNegationDivider;
        }

        void cacheNegationDivider(int cacheNegationDivider) {
            this.cacheNegationDivider = cacheNegationDivider;
            this.cacheNegationDividerBuildStage = 1;
        }

        int cacheVolatileBinsPerHash() {
            if (this.cacheVolatileBinsPerHashBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.cacheVolatileBinsPerHashBuildStage == 0) {
                this.cacheVolatileBinsPerHashBuildStage = -1;
                this.cacheVolatileBinsPerHash = ImmutableBddConfiguration.super.cacheVolatileBinsPerHash();
                this.cacheVolatileBinsPerHashBuildStage = 1;
            }
            return this.cacheVolatileBinsPerHash;
        }

        void cacheVolatileBinsPerHash(int cacheVolatileBinsPerHash) {
            this.cacheVolatileBinsPerHash = cacheVolatileBinsPerHash;
            this.cacheVolatileBinsPerHashBuildStage = 1;
        }

        int cacheVolatileMultiplier() {
            if (this.cacheVolatileMultiplierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.cacheVolatileMultiplierBuildStage == 0) {
                this.cacheVolatileMultiplierBuildStage = -1;
                this.cacheVolatileMultiplier = ImmutableBddConfiguration.super.cacheVolatileMultiplier();
                this.cacheVolatileMultiplierBuildStage = 1;
            }
            return this.cacheVolatileMultiplier;
        }

        void cacheVolatileMultiplier(int cacheVolatileMultiplier) {
            this.cacheVolatileMultiplier = cacheVolatileMultiplier;
            this.cacheVolatileMultiplierBuildStage = 1;
        }

        int initialVariableNodes() {
            if (this.initialVariableNodesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.initialVariableNodesBuildStage == 0) {
                this.initialVariableNodesBuildStage = -1;
                this.initialVariableNodes = ImmutableBddConfiguration.super.initialVariableNodes();
                this.initialVariableNodesBuildStage = 1;
            }
            return this.initialVariableNodes;
        }

        void initialVariableNodes(int initialVariableNodes) {
            this.initialVariableNodes = initialVariableNodes;
            this.initialVariableNodesBuildStage = 1;
        }

        boolean logStatisticsOnShutdown() {
            if (this.logStatisticsOnShutdownBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.logStatisticsOnShutdownBuildStage == 0) {
                this.logStatisticsOnShutdownBuildStage = -1;
                this.logStatisticsOnShutdown = ImmutableBddConfiguration.super.logStatisticsOnShutdown();
                this.logStatisticsOnShutdownBuildStage = 1;
            }
            return this.logStatisticsOnShutdown;
        }

        void logStatisticsOnShutdown(boolean logStatisticsOnShutdown) {
            this.logStatisticsOnShutdown = logStatisticsOnShutdown;
            this.logStatisticsOnShutdownBuildStage = 1;
        }

        int maximumNodeTableGrowth() {
            if (this.maximumNodeTableGrowthBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.maximumNodeTableGrowthBuildStage == 0) {
                this.maximumNodeTableGrowthBuildStage = -1;
                this.maximumNodeTableGrowth = ImmutableBddConfiguration.super.maximumNodeTableGrowth();
                this.maximumNodeTableGrowthBuildStage = 1;
            }
            return this.maximumNodeTableGrowth;
        }

        void maximumNodeTableGrowth(int maximumNodeTableGrowth) {
            this.maximumNodeTableGrowth = maximumNodeTableGrowth;
            this.maximumNodeTableGrowthBuildStage = 1;
        }

        int minimumCacheSize() {
            if (this.minimumCacheSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.minimumCacheSizeBuildStage == 0) {
                this.minimumCacheSizeBuildStage = -1;
                this.minimumCacheSize = ImmutableBddConfiguration.super.minimumCacheSize();
                this.minimumCacheSizeBuildStage = 1;
            }
            return this.minimumCacheSize;
        }

        void minimumCacheSize(int minimumCacheSize) {
            this.minimumCacheSize = minimumCacheSize;
            this.minimumCacheSizeBuildStage = 1;
        }

        int minimumDeadNodesCountForGcInGrow() {
            if (this.minimumDeadNodesCountForGcInGrowBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.minimumDeadNodesCountForGcInGrowBuildStage == 0) {
                this.minimumDeadNodesCountForGcInGrowBuildStage = -1;
                this.minimumDeadNodesCountForGcInGrow = ImmutableBddConfiguration.super.minimumDeadNodesCountForGcInGrow();
                this.minimumDeadNodesCountForGcInGrowBuildStage = 1;
            }
            return this.minimumDeadNodesCountForGcInGrow;
        }

        void minimumDeadNodesCountForGcInGrow(int minimumDeadNodesCountForGcInGrow) {
            this.minimumDeadNodesCountForGcInGrow = minimumDeadNodesCountForGcInGrow;
            this.minimumDeadNodesCountForGcInGrowBuildStage = 1;
        }

        int minimumFreeNodeCountAfterGc() {
            if (this.minimumFreeNodeCountAfterGcBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.minimumFreeNodeCountAfterGcBuildStage == 0) {
                this.minimumFreeNodeCountAfterGcBuildStage = -1;
                this.minimumFreeNodeCountAfterGc = ImmutableBddConfiguration.super.minimumFreeNodeCountAfterGc();
                this.minimumFreeNodeCountAfterGcBuildStage = 1;
            }
            return this.minimumFreeNodeCountAfterGc;
        }

        void minimumFreeNodeCountAfterGc(int minimumFreeNodeCountAfterGc) {
            this.minimumFreeNodeCountAfterGc = minimumFreeNodeCountAfterGc;
            this.minimumFreeNodeCountAfterGcBuildStage = 1;
        }

        float minimumFreeNodePercentageAfterGc() {
            if (this.minimumFreeNodePercentageAfterGcBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.minimumFreeNodePercentageAfterGcBuildStage == 0) {
                this.minimumFreeNodePercentageAfterGcBuildStage = -1;
                this.minimumFreeNodePercentageAfterGc = ImmutableBddConfiguration.super.minimumFreeNodePercentageAfterGc();
                this.minimumFreeNodePercentageAfterGcBuildStage = 1;
            }
            return this.minimumFreeNodePercentageAfterGc;
        }

        void minimumFreeNodePercentageAfterGc(float minimumFreeNodePercentageAfterGc) {
            this.minimumFreeNodePercentageAfterGc = minimumFreeNodePercentageAfterGc;
            this.minimumFreeNodePercentageAfterGcBuildStage = 1;
        }

        int minimumNodeTableGrowth() {
            if (this.minimumNodeTableGrowthBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.minimumNodeTableGrowthBuildStage == 0) {
                this.minimumNodeTableGrowthBuildStage = -1;
                this.minimumNodeTableGrowth = ImmutableBddConfiguration.super.minimumNodeTableGrowth();
                this.minimumNodeTableGrowthBuildStage = 1;
            }
            return this.minimumNodeTableGrowth;
        }

        void minimumNodeTableGrowth(int minimumNodeTableGrowth) {
            this.minimumNodeTableGrowth = minimumNodeTableGrowth;
            this.minimumNodeTableGrowthBuildStage = 1;
        }

        int minimumNodeTableSize() {
            if (this.minimumNodeTableSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.minimumNodeTableSizeBuildStage == 0) {
                this.minimumNodeTableSizeBuildStage = -1;
                this.minimumNodeTableSize = ImmutableBddConfiguration.super.minimumNodeTableSize();
                this.minimumNodeTableSizeBuildStage = 1;
            }
            return this.minimumNodeTableSize;
        }

        void minimumNodeTableSize(int minimumNodeTableSize) {
            this.minimumNodeTableSize = minimumNodeTableSize;
            this.minimumNodeTableSizeBuildStage = 1;
        }

        int nodeTableBigThreshold() {
            if (this.nodeTableBigThresholdBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nodeTableBigThresholdBuildStage == 0) {
                this.nodeTableBigThresholdBuildStage = -1;
                this.nodeTableBigThreshold = ImmutableBddConfiguration.super.nodeTableBigThreshold();
                this.nodeTableBigThresholdBuildStage = 1;
            }
            return this.nodeTableBigThreshold;
        }

        void nodeTableBigThreshold(int nodeTableBigThreshold) {
            this.nodeTableBigThreshold = nodeTableBigThreshold;
            this.nodeTableBigThresholdBuildStage = 1;
        }

        int nodeTableSmallThreshold() {
            if (this.nodeTableSmallThresholdBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nodeTableSmallThresholdBuildStage == 0) {
                this.nodeTableSmallThresholdBuildStage = -1;
                this.nodeTableSmallThreshold = ImmutableBddConfiguration.super.nodeTableSmallThreshold();
                this.nodeTableSmallThresholdBuildStage = 1;
            }
            return this.nodeTableSmallThreshold;
        }

        void nodeTableSmallThreshold(int nodeTableSmallThreshold) {
            this.nodeTableSmallThreshold = nodeTableSmallThreshold;
            this.nodeTableSmallThresholdBuildStage = 1;
        }

        boolean useGlobalComposeCache() {
            if (this.useGlobalComposeCacheBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.useGlobalComposeCacheBuildStage == 0) {
                this.useGlobalComposeCacheBuildStage = -1;
                this.useGlobalComposeCache = ImmutableBddConfiguration.super.useGlobalComposeCache();
                this.useGlobalComposeCacheBuildStage = 1;
            }
            return this.useGlobalComposeCache;
        }

        void useGlobalComposeCache(boolean useGlobalComposeCache) {
            this.useGlobalComposeCache = useGlobalComposeCache;
            this.useGlobalComposeCacheBuildStage = 1;
        }

        boolean useShannonExists() {
            if (this.useShannonExistsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.useShannonExistsBuildStage == 0) {
                this.useShannonExistsBuildStage = -1;
                this.useShannonExists = ImmutableBddConfiguration.super.useShannonExists();
                this.useShannonExistsBuildStage = 1;
            }
            return this.useShannonExists;
        }

        void useShannonExists(boolean useShannonExists) {
            this.useShannonExists = useShannonExists;
            this.useShannonExistsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.cacheBinaryBinsPerHashBuildStage == -1) {
                attributes.add("cacheBinaryBinsPerHash");
            }
            if (this.cacheBinaryDividerBuildStage == -1) {
                attributes.add("cacheBinaryDivider");
            }
            if (this.cacheComposeDividerBuildStage == -1) {
                attributes.add("cacheComposeDivider");
            }
            if (this.cacheSatisfactionBinsPerHashBuildStage == -1) {
                attributes.add("cacheSatisfactionBinsPerHash");
            }
            if (this.cacheSatisfactionDividerBuildStage == -1) {
                attributes.add("cacheSatisfactionDivider");
            }
            if (this.cacheTernaryBinsPerHashBuildStage == -1) {
                attributes.add("cacheTernaryBinsPerHash");
            }
            if (this.cacheTernaryDividerBuildStage == -1) {
                attributes.add("cacheTernaryDivider");
            }
            if (this.cacheNegationBinsPerHashBuildStage == -1) {
                attributes.add("cacheNegationBinsPerHash");
            }
            if (this.cacheNegationDividerBuildStage == -1) {
                attributes.add("cacheNegationDivider");
            }
            if (this.cacheVolatileBinsPerHashBuildStage == -1) {
                attributes.add("cacheVolatileBinsPerHash");
            }
            if (this.cacheVolatileMultiplierBuildStage == -1) {
                attributes.add("cacheVolatileMultiplier");
            }
            if (this.initialVariableNodesBuildStage == -1) {
                attributes.add("initialVariableNodes");
            }
            if (this.logStatisticsOnShutdownBuildStage == -1) {
                attributes.add("logStatisticsOnShutdown");
            }
            if (this.maximumNodeTableGrowthBuildStage == -1) {
                attributes.add("maximumNodeTableGrowth");
            }
            if (this.minimumCacheSizeBuildStage == -1) {
                attributes.add("minimumCacheSize");
            }
            if (this.minimumDeadNodesCountForGcInGrowBuildStage == -1) {
                attributes.add("minimumDeadNodesCountForGcInGrow");
            }
            if (this.minimumFreeNodeCountAfterGcBuildStage == -1) {
                attributes.add("minimumFreeNodeCountAfterGc");
            }
            if (this.minimumFreeNodePercentageAfterGcBuildStage == -1) {
                attributes.add("minimumFreeNodePercentageAfterGc");
            }
            if (this.minimumNodeTableGrowthBuildStage == -1) {
                attributes.add("minimumNodeTableGrowth");
            }
            if (this.minimumNodeTableSizeBuildStage == -1) {
                attributes.add("minimumNodeTableSize");
            }
            if (this.nodeTableBigThresholdBuildStage == -1) {
                attributes.add("nodeTableBigThreshold");
            }
            if (this.nodeTableSmallThresholdBuildStage == -1) {
                attributes.add("nodeTableSmallThreshold");
            }
            if (this.useGlobalComposeCacheBuildStage == -1) {
                attributes.add("useGlobalComposeCache");
            }
            if (this.useShannonExistsBuildStage == -1) {
                attributes.add("useShannonExists");
            }
            return "Cannot build BddConfiguration, attribute initializers form cycle" + attributes;
        }
    }
}

