/*
 * Decompiled with CFR 0.152.
 */
package jhoafparser.util;

import jhoafparser.ast.AtomLabel;
import jhoafparser.ast.BooleanExpression;
import jhoafparser.consumer.HOAConsumerException;
import jhoafparser.storage.UniqueTable;

public class ImplicitEdgeHelper {
    private int numberOfAPs;
    private long edgeIndex = 0L;
    private long edgesPerState = 0L;
    private boolean inState = false;
    private Integer stateId = null;

    public ImplicitEdgeHelper(int numberOfAPs) {
        this.numberOfAPs = numberOfAPs;
        this.edgesPerState = 1L << numberOfAPs;
    }

    public long getEdgesPerState() {
        return this.edgesPerState;
    }

    public void startOfState(int stateId) throws UnsupportedOperationException {
        if (this.inState) {
            throw new UnsupportedOperationException("ImplicitEdgeHelper: startOfState(" + stateId + ") without previous call to endOfState()");
        }
        this.edgeIndex = 0L;
        this.stateId = stateId;
        this.inState = true;
    }

    public long nextImplicitEdge() throws HOAConsumerException, UnsupportedOperationException {
        long currentEdgeIndex;
        if (!this.inState) {
            throw new UnsupportedOperationException("ImplicitEdgeHelper: nextImplicitEdge() without previous call to startOfState()");
        }
        if ((currentEdgeIndex = this.edgeIndex++) >= this.edgesPerState) {
            throw new HOAConsumerException("For state " + this.stateId + ", more edges than allowed for " + this.numberOfAPs + " atomic propositions");
        }
        return currentEdgeIndex;
    }

    public BooleanExpression<AtomLabel> toExplicitLabel(long implicitIndex, UniqueTable<BooleanExpression<AtomLabel>> uniqueTable) {
        if (this.numberOfAPs == 0) {
            return uniqueTable.findOrAdd(new BooleanExpression<boolean>(true));
        }
        BooleanExpression<AtomLabel> result = null;
        for (int i = 0; i < this.numberOfAPs; ++i) {
            BooleanExpression<AtomLabel> literal = uniqueTable.findOrAdd(new BooleanExpression<AtomLabel>(AtomLabel.createAPIndex(i)));
            if (implicitIndex % 2L == 0L) {
                literal = uniqueTable.findOrAdd(literal.not());
            }
            implicitIndex /= 2L;
            result = result == null ? literal : uniqueTable.findOrAdd(result.and(literal));
        }
        return result;
    }

    public void endOfState() throws HOAConsumerException {
        if (!this.inState) {
            throw new UnsupportedOperationException("ImplicitEdgeHelper: endOfState() without previous call to startOfState()");
        }
        this.inState = false;
        if (this.edgeIndex > 0L && this.edgeIndex != this.edgesPerState) {
            throw new HOAConsumerException("For state " + this.stateId + ", less edges than required for " + this.numberOfAPs + " atomic propositions");
        }
    }
}

