/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.naturals;

public final class BitUtil {
    private BitUtil() {
    }

    public static long mask(int from, int to) {
        assert (0 <= from && from <= to && to <= 64);
        if (from == to) {
            return 0L;
        }
        if (to == 64) {
            return (1L << from) - 1L ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return (1L << to) - 1L & ((1L << from) - 1L ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static long maskTo(int to) {
        assert (0 <= to && to <= 64);
        if (to == 64) {
            return -1L;
        }
        return (1L << to) - 1L;
    }

    public static int nextBit(long store, int index) {
        long shifted = store >>> index - 1;
        int num = Long.numberOfTrailingZeros(shifted);
        if (num == 64) {
            return -1;
        }
        assert (num < 64 - index);
        return num + index + 1;
    }
}

