/*
 * Decompiled with CFR 0.152.
 */
package owl.run;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import owl.run.Pipeline;
import owl.run.modules.InputReader;
import owl.run.modules.OutputWriter;
import owl.run.modules.Transformer;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Pipeline", generator="Immutables")
@Immutable
public final class ImmutablePipeline
extends Pipeline {
    private final InputReader input;
    private final OutputWriter output;
    private final ImmutableList<Transformer> transformers;

    private ImmutablePipeline(InputReader input, OutputWriter output, Iterable<? extends Transformer> transformers) {
        this.input = Objects.requireNonNull(input, "input");
        this.output = Objects.requireNonNull(output, "output");
        this.transformers = ImmutableList.copyOf(transformers);
    }

    private ImmutablePipeline(ImmutablePipeline original, InputReader input, OutputWriter output, ImmutableList<Transformer> transformers) {
        this.input = input;
        this.output = output;
        this.transformers = transformers;
    }

    @Override
    public InputReader input() {
        return this.input;
    }

    @Override
    public OutputWriter output() {
        return this.output;
    }

    public ImmutableList<Transformer> transformers() {
        return this.transformers;
    }

    public final ImmutablePipeline withInput(InputReader value) {
        if (this.input == value) {
            return this;
        }
        InputReader newValue = Objects.requireNonNull(value, "input");
        return new ImmutablePipeline(this, newValue, this.output, this.transformers);
    }

    public final ImmutablePipeline withOutput(OutputWriter value) {
        if (this.output == value) {
            return this;
        }
        OutputWriter newValue = Objects.requireNonNull(value, "output");
        return new ImmutablePipeline(this, this.input, newValue, this.transformers);
    }

    public final ImmutablePipeline withTransformers(Transformer ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutablePipeline(this, this.input, this.output, (ImmutableList<Transformer>)newValue);
    }

    public final ImmutablePipeline withTransformers(Iterable<? extends Transformer> elements) {
        if (this.transformers == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutablePipeline(this, this.input, this.output, (ImmutableList<Transformer>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePipeline && this.equalTo((ImmutablePipeline)another);
    }

    private boolean equalTo(ImmutablePipeline another) {
        return this.input.equals(another.input) && this.output.equals(another.output) && this.transformers.equals(another.transformers);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.input.hashCode();
        h += (h << 5) + this.output.hashCode();
        h += (h << 5) + this.transformers.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Pipeline").omitNullValues().add("input", (Object)this.input).add("output", (Object)this.output).add("transformers", this.transformers).toString();
    }

    public static ImmutablePipeline of(InputReader input, OutputWriter output, List<Transformer> transformers) {
        return ImmutablePipeline.of(input, output, transformers);
    }

    public static ImmutablePipeline of(InputReader input, OutputWriter output, Iterable<? extends Transformer> transformers) {
        return new ImmutablePipeline(input, output, transformers);
    }

    public static ImmutablePipeline copyOf(Pipeline instance) {
        if (instance instanceof ImmutablePipeline) {
            return (ImmutablePipeline)instance;
        }
        return ImmutablePipeline.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Pipeline", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_INPUT = 1L;
        private static final long INIT_BIT_OUTPUT = 2L;
        private long initBits = 3L;
        @Nullable
        private InputReader input;
        @Nullable
        private OutputWriter output;
        private ImmutableList.Builder<Transformer> transformers = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Pipeline instance) {
            Objects.requireNonNull(instance, "instance");
            this.input(instance.input());
            this.output(instance.output());
            this.addAllTransformers(instance.transformers());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder input(InputReader input) {
            this.input = Objects.requireNonNull(input, "input");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder output(OutputWriter output) {
            this.output = Objects.requireNonNull(output, "output");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTransformers(Transformer element) {
            this.transformers.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTransformers(Transformer ... elements) {
            this.transformers.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder transformers(Iterable<? extends Transformer> elements) {
            this.transformers = ImmutableList.builder();
            return this.addAllTransformers(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllTransformers(Iterable<? extends Transformer> elements) {
            this.transformers.addAll(elements);
            return this;
        }

        public ImmutablePipeline build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePipeline(null, this.input, this.output, (ImmutableList<Transformer>)this.transformers.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("input");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("output");
            }
            return "Cannot build Pipeline, some of required attributes are not set " + attributes;
        }
    }
}

